/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.transport;

import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.apache.logging.log4j.Logger;
import conductor.org.apache.logging.log4j.message.ParameterizedMessage;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.common.CheckedBiConsumer;
import conductor.org.elasticsearch.common.component.Lifecycle;
import conductor.org.elasticsearch.common.lease.Releasable;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.unit.TimeValue;
import conductor.org.elasticsearch.common.util.concurrent.AbstractLifecycleRunnable;
import conductor.org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import conductor.org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import conductor.org.elasticsearch.common.util.concurrent.KeyedLock;
import conductor.org.elasticsearch.core.internal.io.IOUtils;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.ConnectTransportException;
import conductor.org.elasticsearch.transport.ConnectionProfile;
import conductor.org.elasticsearch.transport.NodeNotConnectedException;
import conductor.org.elasticsearch.transport.TcpTransport;
import conductor.org.elasticsearch.transport.Transport;
import conductor.org.elasticsearch.transport.TransportConnectionListener;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ConnectionManager
implements Closeable {
    private static final Logger logger = LogManager.getLogger(ConnectionManager.class);
    private final ConcurrentMap<DiscoveryNode, Transport.Connection> connectedNodes = ConcurrentCollections.newConcurrentMap();
    private final KeyedLock<String> connectionLock = new KeyedLock();
    private final Transport transport;
    private final ThreadPool threadPool;
    private final TimeValue pingSchedule;
    private final ConnectionProfile defaultProfile;
    private final Lifecycle lifecycle = new Lifecycle();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ReadWriteLock closeLock = new ReentrantReadWriteLock();
    private final DelegatingNodeConnectionListener connectionListener = new DelegatingNodeConnectionListener();

    public ConnectionManager(Settings settings, Transport transport, ThreadPool threadPool) {
        this(settings, transport, threadPool, ConnectionProfile.buildDefaultConnectionProfile(settings));
    }

    public ConnectionManager(Settings settings, Transport transport, ThreadPool threadPool, ConnectionProfile defaultProfile) {
        this.transport = transport;
        this.threadPool = threadPool;
        this.pingSchedule = TcpTransport.PING_SCHEDULE.get(settings);
        this.defaultProfile = defaultProfile;
        this.lifecycle.moveToStarted();
        if (this.pingSchedule.millis() > 0L) {
            threadPool.schedule(this.pingSchedule, "generic", new ScheduledPing());
        }
    }

    public void addListener(TransportConnectionListener listener) {
        this.connectionListener.listeners.addIfAbsent(listener);
    }

    public void removeListener(TransportConnectionListener listener) {
        this.connectionListener.listeners.remove(listener);
    }

    public Transport.Connection openConnection(DiscoveryNode node, ConnectionProfile connectionProfile) {
        ConnectionProfile resolvedProfile = ConnectionProfile.resolveConnectionProfile(connectionProfile, this.defaultProfile);
        return this.internalOpenConnection(node, resolvedProfile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connectToNode(DiscoveryNode node, ConnectionProfile connectionProfile, CheckedBiConsumer<Transport.Connection, ConnectionProfile, IOException> connectionValidator) throws ConnectTransportException {
        ConnectionProfile resolvedProfile = ConnectionProfile.resolveConnectionProfile(connectionProfile, this.defaultProfile);
        if (node == null) {
            throw new ConnectTransportException(null, "can't connect to a null node");
        }
        this.closeLock.readLock().lock();
        try {
            this.ensureOpen();
            try (Releasable ignored = this.connectionLock.acquire(node.getId());){
                Transport.Connection connection = (Transport.Connection)this.connectedNodes.get(node);
                if (connection != null) {
                    return;
                }
                boolean success = false;
                try {
                    connection = this.internalOpenConnection(node, resolvedProfile);
                    connectionValidator.accept(connection, resolvedProfile);
                    this.connectedNodes.put(node, connection);
                    if (logger.isDebugEnabled()) {
                        logger.debug("connected to node [{}]", (Object)node);
                    }
                    try {
                        this.connectionListener.onNodeConnected(node);
                    }
                    finally {
                        Transport.Connection finalConnection = connection;
                        connection.addCloseListener(ActionListener.wrap(() -> {
                            this.connectedNodes.remove(node, finalConnection);
                            this.connectionListener.onNodeDisconnected(node);
                        }));
                    }
                    if (connection.isClosed()) {
                        throw new NodeNotConnectedException(node, "connection concurrently closed");
                    }
                    success = true;
                    if (success) return;
                }
                catch (ConnectTransportException e) {
                    try {
                        throw e;
                        catch (Exception e2) {
                            throw new ConnectTransportException(node, "general node connection failure", e2);
                        }
                    }
                    catch (Throwable throwable) {
                        if (success) throw throwable;
                        logger.trace(() -> new ParameterizedMessage("failed to connect to [{}], cleaning dangling connections", (Object)node));
                        IOUtils.closeWhileHandlingException(connection);
                        throw throwable;
                    }
                }
                logger.trace(() -> new ParameterizedMessage("failed to connect to [{}], cleaning dangling connections", (Object)node));
                IOUtils.closeWhileHandlingException(connection);
                return;
            }
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    public Transport.Connection getConnection(DiscoveryNode node) {
        Transport.Connection connection = (Transport.Connection)this.connectedNodes.get(node);
        if (connection == null) {
            throw new NodeNotConnectedException(node, "Node not connected");
        }
        return connection;
    }

    public boolean nodeConnected(DiscoveryNode node) {
        return this.connectedNodes.containsKey(node);
    }

    public void disconnectFromNode(DiscoveryNode node) {
        Transport.Connection nodeChannels = (Transport.Connection)this.connectedNodes.remove(node);
        if (nodeChannels != null) {
            nodeChannels.close();
        }
    }

    public int size() {
        return this.connectedNodes.size();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.lifecycle.moveToStopped();
            CountDownLatch latch = new CountDownLatch(1);
            this.threadPool.generic().execute(() -> {
                this.closeLock.writeLock().lock();
                try {
                    Iterator iterator = this.connectedNodes.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry next = iterator.next();
                        try {
                            IOUtils.closeWhileHandlingException((Closeable)next.getValue());
                        }
                        finally {
                            iterator.remove();
                        }
                    }
                }
                finally {
                    this.closeLock.writeLock().unlock();
                    latch.countDown();
                }
            });
            try {
                try {
                    latch.await(30L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            finally {
                this.lifecycle.moveToClosed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transport.Connection internalOpenConnection(DiscoveryNode node, ConnectionProfile connectionProfile) {
        Transport.Connection connection = this.transport.openConnection(node, connectionProfile);
        try {
            this.connectionListener.onConnectionOpened(connection);
        }
        finally {
            connection.addCloseListener(ActionListener.wrap(() -> this.connectionListener.onConnectionClosed(connection)));
        }
        if (connection.isClosed()) {
            throw new ConnectTransportException(node, "a channel closed while connecting");
        }
        return connection;
    }

    private void ensureOpen() {
        if (!this.lifecycle.started()) {
            throw new IllegalStateException("connection manager is closed");
        }
    }

    private static final class DelegatingNodeConnectionListener
    implements TransportConnectionListener {
        private final CopyOnWriteArrayList<TransportConnectionListener> listeners = new CopyOnWriteArrayList();

        private DelegatingNodeConnectionListener() {
        }

        @Override
        public void onNodeDisconnected(DiscoveryNode key) {
            for (TransportConnectionListener listener : this.listeners) {
                listener.onNodeDisconnected(key);
            }
        }

        @Override
        public void onNodeConnected(DiscoveryNode node) {
            for (TransportConnectionListener listener : this.listeners) {
                listener.onNodeConnected(node);
            }
        }

        @Override
        public void onConnectionOpened(Transport.Connection connection) {
            for (TransportConnectionListener listener : this.listeners) {
                listener.onConnectionOpened(connection);
            }
        }

        @Override
        public void onConnectionClosed(Transport.Connection connection) {
            for (TransportConnectionListener listener : this.listeners) {
                listener.onConnectionClosed(connection);
            }
        }
    }

    private class ScheduledPing
    extends AbstractLifecycleRunnable {
        private ScheduledPing() {
            super(ConnectionManager.this.lifecycle, logger);
        }

        @Override
        protected void doRunInLifecycle() {
            for (Map.Entry entry : ConnectionManager.this.connectedNodes.entrySet()) {
                Transport.Connection connection = (Transport.Connection)entry.getValue();
                if (connection.sendPing()) continue;
                logger.warn("attempted to send ping to connection without support for pings [{}]", (Object)connection);
            }
        }

        @Override
        protected void onAfterInLifecycle() {
            try {
                ConnectionManager.this.threadPool.schedule(ConnectionManager.this.pingSchedule, "generic", this);
            }
            catch (EsRejectedExecutionException ex) {
                if (ex.isExecutorShutdown()) {
                    logger.debug("couldn't schedule new ping execution, executor is shutting down", (Throwable)ex);
                }
                throw ex;
            }
        }

        @Override
        public void onFailure(Exception e) {
            if (ConnectionManager.this.lifecycle.stoppedOrClosed()) {
                logger.trace("failed to send ping transport message", (Throwable)e);
            } else {
                logger.warn("failed to send ping transport message", (Throwable)e);
            }
        }
    }
}

