/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.transport.netty4;

import conductor.io.netty.channel.Channel;
import conductor.io.netty.channel.ChannelOption;
import conductor.io.netty.channel.ChannelPromise;
import conductor.io.netty.util.concurrent.Future;
import conductor.io.netty.util.concurrent.GenericFutureListener;
import conductor.org.elasticsearch.ExceptionsHelper;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.transport.TcpChannel;
import conductor.org.elasticsearch.transport.TransportException;
import conductor.org.elasticsearch.transport.netty4.Netty4Utils;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

public class NettyTcpChannel
implements TcpChannel {
    private final Channel channel;
    private final CompletableFuture<Void> closeContext = new CompletableFuture();

    NettyTcpChannel(Channel channel) {
        this.channel = channel;
        this.channel.closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
            if (f.isSuccess()) {
                this.closeContext.complete(null);
            } else {
                Throwable cause = f.cause();
                if (cause instanceof Error) {
                    ExceptionsHelper.maybeDieOnAnotherThread(cause);
                    this.closeContext.completeExceptionally(cause);
                } else {
                    this.closeContext.completeExceptionally(cause);
                }
            }
        }));
    }

    @Override
    public void close() {
        this.channel.close();
    }

    @Override
    public void addCloseListener(ActionListener<Void> listener) {
        this.closeContext.whenComplete((BiConsumer)ActionListener.toBiConsumer(listener));
    }

    @Override
    public void setSoLinger(int value) {
        this.channel.config().setOption(ChannelOption.SO_LINGER, value);
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }

    @Override
    public void sendMessage(BytesReference reference, ActionListener<Void> listener) {
        ChannelPromise writePromise = this.channel.newPromise();
        writePromise.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
            if (f.isSuccess()) {
                listener.onResponse(null);
            } else {
                Throwable cause = f.cause();
                ExceptionsHelper.maybeDieOnAnotherThread(cause);
                assert (cause instanceof Exception);
                listener.onFailure((Exception)cause);
            }
        }));
        this.channel.writeAndFlush(Netty4Utils.toByteBuf(reference), writePromise);
        if (this.channel.eventLoop().isShutdown()) {
            listener.onFailure(new TransportException("Cannot send message, event loop is shutting down."));
        }
    }

    public Channel getLowLevelChannel() {
        return this.channel;
    }

    public String toString() {
        return "NettyTcpChannel{localAddress=" + this.getLocalAddress() + ", remoteAddress=" + this.channel.remoteAddress() + '}';
    }
}

