/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.index;

import conductor.org.apache.lucene.codecs.DocValuesProducer;
import conductor.org.apache.lucene.codecs.FieldsProducer;
import conductor.org.apache.lucene.codecs.NormsProducer;
import conductor.org.apache.lucene.codecs.StoredFieldsReader;
import conductor.org.apache.lucene.codecs.TermVectorsReader;
import conductor.org.apache.lucene.index.BinaryDocValues;
import conductor.org.apache.lucene.index.CodecReader;
import conductor.org.apache.lucene.index.DocValuesType;
import conductor.org.apache.lucene.index.FieldInfo;
import conductor.org.apache.lucene.index.FieldInfos;
import conductor.org.apache.lucene.index.Fields;
import conductor.org.apache.lucene.index.IndexReader;
import conductor.org.apache.lucene.index.LeafMetaData;
import conductor.org.apache.lucene.index.LeafReader;
import conductor.org.apache.lucene.index.NumericDocValues;
import conductor.org.apache.lucene.index.PointValues;
import conductor.org.apache.lucene.index.SortedDocValues;
import conductor.org.apache.lucene.index.SortedNumericDocValues;
import conductor.org.apache.lucene.index.SortedSetDocValues;
import conductor.org.apache.lucene.index.StoredFieldVisitor;
import conductor.org.apache.lucene.index.Terms;
import conductor.org.apache.lucene.util.Bits;
import java.io.IOException;
import java.util.Objects;

class MergeReaderWrapper
extends LeafReader {
    final CodecReader in;
    final FieldsProducer fields;
    final NormsProducer norms;
    final DocValuesProducer docValues;
    final StoredFieldsReader store;
    final TermVectorsReader vectors;

    MergeReaderWrapper(CodecReader in) throws IOException {
        this.in = in;
        FieldsProducer fields = in.getPostingsReader();
        if (fields != null) {
            fields = fields.getMergeInstance();
        }
        this.fields = fields;
        NormsProducer norms = in.getNormsReader();
        if (norms != null) {
            norms = norms.getMergeInstance();
        }
        this.norms = norms;
        DocValuesProducer docValues = in.getDocValuesReader();
        if (docValues != null) {
            docValues = docValues.getMergeInstance();
        }
        this.docValues = docValues;
        StoredFieldsReader store = in.getFieldsReader();
        if (store != null) {
            store = store.getMergeInstance();
        }
        this.store = store;
        TermVectorsReader vectors = in.getTermVectorsReader();
        if (vectors != null) {
            vectors = vectors.getMergeInstance();
        }
        this.vectors = vectors;
    }

    @Override
    public Terms terms(String field) throws IOException {
        this.ensureOpen();
        return this.fields.terms(field);
    }

    @Override
    public NumericDocValues getNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() != DocValuesType.NUMERIC) {
            return null;
        }
        return this.docValues.getNumeric(fi);
    }

    @Override
    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() != DocValuesType.BINARY) {
            return null;
        }
        return this.docValues.getBinary(fi);
    }

    @Override
    public SortedDocValues getSortedDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() != DocValuesType.SORTED) {
            return null;
        }
        return this.docValues.getSorted(fi);
    }

    @Override
    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() != DocValuesType.SORTED_NUMERIC) {
            return null;
        }
        return this.docValues.getSortedNumeric(fi);
    }

    @Override
    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() != DocValuesType.SORTED_SET) {
            return null;
        }
        return this.docValues.getSortedSet(fi);
    }

    @Override
    public NumericDocValues getNormValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || !fi.hasNorms()) {
            return null;
        }
        return this.norms.getNorms(fi);
    }

    @Override
    public FieldInfos getFieldInfos() {
        return this.in.getFieldInfos();
    }

    @Override
    public Bits getLiveDocs() {
        return this.in.getLiveDocs();
    }

    @Override
    public void checkIntegrity() throws IOException {
        this.in.checkIntegrity();
    }

    @Override
    public Fields getTermVectors(int docID) throws IOException {
        this.ensureOpen();
        this.checkBounds(docID);
        if (this.vectors == null) {
            return null;
        }
        return this.vectors.get(docID);
    }

    @Override
    public PointValues getPointValues(String fieldName) throws IOException {
        return this.in.getPointValues(fieldName);
    }

    @Override
    public int numDocs() {
        return this.in.numDocs();
    }

    @Override
    public int maxDoc() {
        return this.in.maxDoc();
    }

    @Override
    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
        this.ensureOpen();
        this.checkBounds(docID);
        this.store.visitDocument(docID, visitor);
    }

    @Override
    protected void doClose() throws IOException {
        this.in.close();
    }

    @Override
    public IndexReader.CacheHelper getCoreCacheHelper() {
        return this.in.getCoreCacheHelper();
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    private void checkBounds(int docID) {
        Objects.checkIndex(docID, this.maxDoc());
    }

    public String toString() {
        return "MergeReaderWrapper(" + this.in + ")";
    }

    @Override
    public LeafMetaData getMetaData() {
        return this.in.getMetaData();
    }
}

