/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.queryparser.xml.builders;

import conductor.org.apache.lucene.queryparser.xml.DOMUtils;
import conductor.org.apache.lucene.queryparser.xml.ParserException;
import conductor.org.apache.lucene.queryparser.xml.builders.SpanBuilderBase;
import conductor.org.apache.lucene.queryparser.xml.builders.SpanQueryBuilder;
import conductor.org.apache.lucene.search.spans.SpanBoostQuery;
import conductor.org.apache.lucene.search.spans.SpanOrQuery;
import conductor.org.apache.lucene.search.spans.SpanQuery;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SpanOrBuilder
extends SpanBuilderBase {
    private final SpanQueryBuilder factory;

    public SpanOrBuilder(SpanQueryBuilder factory) {
        this.factory = factory;
    }

    @Override
    public SpanQuery getSpanQuery(Element e) throws ParserException {
        ArrayList<SpanQuery> clausesList = new ArrayList<SpanQuery>();
        for (Node kid = e.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            if (kid.getNodeType() != 1) continue;
            SpanQuery clause = this.factory.getSpanQuery((Element)kid);
            clausesList.add(clause);
        }
        SpanQuery[] clauses = clausesList.toArray(new SpanQuery[clausesList.size()]);
        SpanOrQuery soq = new SpanOrQuery(clauses);
        float boost = DOMUtils.getAttribute(e, "boost", 1.0f);
        return new SpanBoostQuery(soq, boost);
    }
}

