/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search;

import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.index.Terms;
import conductor.org.apache.lucene.index.TermsEnum;
import conductor.org.apache.lucene.search.MultiTermQuery;
import conductor.org.apache.lucene.util.AttributeSource;
import conductor.org.apache.lucene.util.automaton.Automaton;
import conductor.org.apache.lucene.util.automaton.CompiledAutomaton;
import java.io.IOException;

public class AutomatonQuery
extends MultiTermQuery {
    protected final Automaton automaton;
    protected final CompiledAutomaton compiled;
    protected final Term term;
    protected final boolean automatonIsBinary;

    public AutomatonQuery(Term term, Automaton automaton) {
        this(term, automaton, 10000);
    }

    public AutomatonQuery(Term term, Automaton automaton, int maxDeterminizedStates) {
        this(term, automaton, maxDeterminizedStates, false);
    }

    public AutomatonQuery(Term term, Automaton automaton, int maxDeterminizedStates, boolean isBinary) {
        super(term.field());
        this.term = term;
        this.automaton = automaton;
        this.automatonIsBinary = isBinary;
        this.compiled = new CompiledAutomaton(automaton, null, true, maxDeterminizedStates, isBinary);
    }

    @Override
    protected TermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
        return this.compiled.getTermsEnum(terms);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.compiled.hashCode();
        result = 31 * result + (this.term == null ? 0 : this.term.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AutomatonQuery other = (AutomatonQuery)obj;
        if (!this.compiled.equals(other.compiled)) {
            return false;
        }
        return !(this.term == null ? other.term != null : !this.term.equals(other.term));
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append(this.getClass().getSimpleName());
        buffer.append(" {");
        buffer.append('\n');
        buffer.append(this.automaton.toString());
        buffer.append("}");
        return buffer.toString();
    }

    public Automaton getAutomaton() {
        return this.automaton;
    }

    public boolean isAutomatonBinary() {
        return this.automatonIsBinary;
    }
}

