/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.suggest.analyzing;

import conductor.org.apache.lucene.analysis.CharArraySet;
import conductor.org.apache.lucene.analysis.TokenFilter;
import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import conductor.org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import conductor.org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import conductor.org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import conductor.org.apache.lucene.util.AttributeSource;
import java.io.IOException;

public final class SuggestStopFilter
extends TokenFilter {
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final PositionIncrementAttribute posIncAtt = this.addAttribute(PositionIncrementAttribute.class);
    private final KeywordAttribute keywordAtt = this.addAttribute(KeywordAttribute.class);
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
    private final CharArraySet stopWords;
    private AttributeSource.State endState;

    public SuggestStopFilter(TokenStream input, CharArraySet stopWords) {
        super(input);
        this.stopWords = stopWords;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.endState = null;
    }

    @Override
    public void end() throws IOException {
        if (this.endState == null) {
            super.end();
        } else {
            this.restoreState(this.endState);
        }
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.endState != null) {
            return false;
        }
        if (!this.input.incrementToken()) {
            return false;
        }
        int skippedPositions = 0;
        while (this.stopWords.contains(this.termAtt.buffer(), 0, this.termAtt.length())) {
            int posInc = this.posIncAtt.getPositionIncrement();
            int endOffset = this.offsetAtt.endOffset();
            AttributeSource.State sav = this.captureState();
            if (this.input.incrementToken()) {
                skippedPositions += posInc;
                continue;
            }
            this.clearAttributes();
            this.input.end();
            this.endState = this.captureState();
            int finalEndOffset = this.offsetAtt.endOffset();
            assert (finalEndOffset >= endOffset);
            if (finalEndOffset > endOffset) {
                return false;
            }
            this.restoreState(sav);
            this.posIncAtt.setPositionIncrement(skippedPositions + this.posIncAtt.getPositionIncrement());
            this.keywordAtt.setKeyword(true);
            return true;
        }
        this.posIncAtt.setPositionIncrement(skippedPositions + this.posIncAtt.getPositionIncrement());
        return true;
    }
}

