/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.util;

import conductor.org.apache.lucene.util.MathUtil;
import conductor.org.apache.lucene.util.Sorter;

public abstract class IntroSorter
extends Sorter {
    @Override
    public final void sort(int from, int to) {
        this.checkRange(from, to);
        this.quicksort(from, to, 2 * MathUtil.log(to - from, 2));
    }

    void quicksort(int from, int to, int maxDepth) {
        if (to - from < 20) {
            this.binarySort(from, to);
            return;
        }
        if (--maxDepth < 0) {
            this.heapSort(from, to);
            return;
        }
        int mid = from + to >>> 1;
        if (this.compare(from, mid) > 0) {
            this.swap(from, mid);
        }
        if (this.compare(mid, to - 1) > 0) {
            this.swap(mid, to - 1);
            if (this.compare(from, mid) > 0) {
                this.swap(from, mid);
            }
        }
        int left = from + 1;
        int right = to - 2;
        this.setPivot(mid);
        while (true) {
            if (this.comparePivot(right) < 0) {
                --right;
                continue;
            }
            while (left < right && this.comparePivot(left) >= 0) {
                ++left;
            }
            if (left >= right) break;
            this.swap(left, right);
            --right;
        }
        this.quicksort(from, left + 1, maxDepth);
        this.quicksort(left + 1, to, maxDepth);
    }

    @Override
    protected abstract void setPivot(int var1);

    @Override
    protected abstract int comparePivot(int var1);

    @Override
    protected int compare(int i, int j) {
        this.setPivot(i);
        return this.comparePivot(j);
    }
}

