/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.search;

import conductor.org.apache.logging.log4j.Logger;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.search.AbstractSearchAsyncAction;
import conductor.org.elasticsearch.action.search.DfsQueryPhase;
import conductor.org.elasticsearch.action.search.FetchSearchPhase;
import conductor.org.elasticsearch.action.search.InitialSearchPhase;
import conductor.org.elasticsearch.action.search.SearchActionListener;
import conductor.org.elasticsearch.action.search.SearchPhase;
import conductor.org.elasticsearch.action.search.SearchPhaseContext;
import conductor.org.elasticsearch.action.search.SearchPhaseController;
import conductor.org.elasticsearch.action.search.SearchRequest;
import conductor.org.elasticsearch.action.search.SearchResponse;
import conductor.org.elasticsearch.action.search.SearchShardIterator;
import conductor.org.elasticsearch.action.search.SearchTask;
import conductor.org.elasticsearch.action.search.SearchTransportService;
import conductor.org.elasticsearch.action.search.TransportSearchAction;
import conductor.org.elasticsearch.cluster.routing.GroupShardsIterator;
import conductor.org.elasticsearch.cluster.routing.ShardRouting;
import conductor.org.elasticsearch.search.SearchPhaseResult;
import conductor.org.elasticsearch.search.dfs.DfsSearchResult;
import conductor.org.elasticsearch.search.internal.AliasFilter;
import conductor.org.elasticsearch.transport.Transport;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;

final class SearchDfsQueryThenFetchAsyncAction
extends AbstractSearchAsyncAction<DfsSearchResult> {
    private final SearchPhaseController searchPhaseController;

    SearchDfsQueryThenFetchAsyncAction(Logger logger, SearchTransportService searchTransportService, BiFunction<String, String, Transport.Connection> nodeIdToConnection, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, Map<String, Set<String>> indexRoutings, SearchPhaseController searchPhaseController, Executor executor, SearchRequest request, ActionListener<SearchResponse> listener, GroupShardsIterator<SearchShardIterator> shardsIts, TransportSearchAction.SearchTimeProvider timeProvider, long clusterStateVersion, SearchTask task, SearchResponse.Clusters clusters) {
        super("dfs", logger, searchTransportService, nodeIdToConnection, aliasFilter, concreteIndexBoosts, indexRoutings, executor, request, listener, shardsIts, timeProvider, clusterStateVersion, task, new InitialSearchPhase.ArraySearchPhaseResults(shardsIts.size()), request.getMaxConcurrentShardRequests(), clusters);
        this.searchPhaseController = searchPhaseController;
    }

    @Override
    protected void executePhaseOnShard(SearchShardIterator shardIt, ShardRouting shard, SearchActionListener<DfsSearchResult> listener) {
        this.getSearchTransport().sendExecuteDfs(this.getConnection(shardIt.getClusterAlias(), shard.currentNodeId()), this.buildShardSearchRequest(shardIt), this.getTask(), listener);
    }

    @Override
    protected SearchPhase getNextPhase(InitialSearchPhase.SearchPhaseResults<DfsSearchResult> results, SearchPhaseContext context) {
        return new DfsQueryPhase(results.getAtomicArray(), this.searchPhaseController, queryResults -> new FetchSearchPhase((InitialSearchPhase.SearchPhaseResults<SearchPhaseResult>)queryResults, this.searchPhaseController, context), context);
    }
}

