/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.seqno;

import conductor.org.apache.lucene.util.FixedBitSet;
import conductor.org.apache.lucene.util.RamUsageEstimator;

public final class CountedBitSet {
    static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(CountedBitSet.class);
    private short onBits;
    private FixedBitSet bitset;

    public CountedBitSet(short numBits) {
        if (numBits <= 0) {
            throw new IllegalArgumentException("Number of bits must be positive. Given [" + numBits + "]");
        }
        this.onBits = 0;
        this.bitset = new FixedBitSet(numBits);
    }

    public boolean get(int index) {
        assert (0 <= index && index < this.length());
        assert (this.bitset == null || this.onBits < this.bitset.length()) : "Bitset should be released when all bits are set";
        return this.bitset == null ? true : this.bitset.get(index);
    }

    public void set(int index) {
        boolean wasOn;
        assert (0 <= index && index < this.length());
        assert (this.bitset == null || this.onBits < this.bitset.length()) : "Bitset should be released when all bits are set";
        if (this.bitset != null && !(wasOn = this.bitset.getAndSet(index))) {
            this.onBits = (short)(this.onBits + 1);
            if (this.onBits == this.bitset.length()) {
                this.bitset = null;
            }
        }
    }

    int cardinality() {
        return this.onBits;
    }

    int length() {
        return this.bitset == null ? this.onBits : this.bitset.length();
    }

    boolean isInternalBitsetReleased() {
        return this.bitset == null;
    }
}

