/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.monitor.jvm;

import conductor.org.apache.logging.log4j.message.ParameterizedMessage;
import conductor.org.elasticsearch.common.logging.Loggers;
import java.lang.management.ManagementFactory;

class JvmPid {
    private static final long PID = JvmPid.initializePid();

    JvmPid() {
    }

    static long getPid() {
        return PID;
    }

    private static long initializePid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        try {
            return Long.parseLong(name.split("@")[0]);
        }
        catch (NumberFormatException e) {
            Loggers.getLogger(JvmPid.class).debug(new ParameterizedMessage("failed parsing PID from [{}]", (Object)name), (Throwable)e);
            return -1L;
        }
    }
}

