/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.join;

import conductor.org.apache.lucene.index.BinaryDocValues;
import conductor.org.apache.lucene.index.SortedSetDocValues;
import conductor.org.apache.lucene.search.Scorer;
import conductor.org.apache.lucene.search.join.DocValuesTermsCollector;
import conductor.org.apache.lucene.search.join.GenericTermsCollector;
import conductor.org.apache.lucene.search.join.ScoreMode;
import conductor.org.apache.lucene.util.ArrayUtil;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.apache.lucene.util.BytesRefHash;
import java.io.IOException;
import java.util.Arrays;

abstract class TermsWithScoreCollector<DV>
extends DocValuesTermsCollector<DV>
implements GenericTermsCollector {
    private static final int INITIAL_ARRAY_SIZE = 0;
    final BytesRefHash collectedTerms = new BytesRefHash();
    final ScoreMode scoreMode;
    Scorer scorer;
    float[] scoreSums = new float[0];

    TermsWithScoreCollector(DocValuesTermsCollector.Function<DV> docValuesCall, ScoreMode scoreMode) {
        super(docValuesCall);
        this.scoreMode = scoreMode;
        if (scoreMode == ScoreMode.Min) {
            Arrays.fill(this.scoreSums, Float.POSITIVE_INFINITY);
        } else if (scoreMode == ScoreMode.Max) {
            Arrays.fill(this.scoreSums, Float.NEGATIVE_INFINITY);
        }
    }

    @Override
    public BytesRefHash getCollectedTerms() {
        return this.collectedTerms;
    }

    @Override
    public float[] getScoresPerTerm() {
        return this.scoreSums;
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.scorer = scorer;
    }

    static TermsWithScoreCollector<?> create(String field, boolean multipleValuesPerDocument, ScoreMode scoreMode) {
        if (multipleValuesPerDocument) {
            switch (scoreMode) {
                case Avg: {
                    return new MV.Avg(TermsWithScoreCollector.sortedSetDocValues(field));
                }
            }
            return new MV(TermsWithScoreCollector.sortedSetDocValues(field), scoreMode);
        }
        switch (scoreMode) {
            case Avg: {
                return new SV.Avg(TermsWithScoreCollector.binaryDocValues(field));
            }
        }
        return new SV(TermsWithScoreCollector.binaryDocValues(field), scoreMode);
    }

    @Override
    public boolean needsScores() {
        return true;
    }

    static class MV
    extends TermsWithScoreCollector<SortedSetDocValues> {
        MV(DocValuesTermsCollector.Function<SortedSetDocValues> docValuesCall, ScoreMode scoreMode) {
            super(docValuesCall, scoreMode);
        }

        @Override
        public void collect(int doc) throws IOException {
            if (((SortedSetDocValues)this.docValues).advanceExact(doc)) {
                long ord;
                block5: while ((ord = ((SortedSetDocValues)this.docValues).nextOrd()) != -1L) {
                    int termID = this.collectedTerms.add(((SortedSetDocValues)this.docValues).lookupOrd(ord));
                    if (termID < 0) {
                        termID = -termID - 1;
                    } else if (termID >= this.scoreSums.length) {
                        int begin = this.scoreSums.length;
                        this.scoreSums = ArrayUtil.grow(this.scoreSums);
                        if (this.scoreMode == ScoreMode.Min) {
                            Arrays.fill(this.scoreSums, begin, this.scoreSums.length, Float.POSITIVE_INFINITY);
                        } else if (this.scoreMode == ScoreMode.Max) {
                            Arrays.fill(this.scoreSums, begin, this.scoreSums.length, Float.NEGATIVE_INFINITY);
                        }
                    }
                    switch (this.scoreMode) {
                        case Total: {
                            int n = termID;
                            this.scoreSums[n] = this.scoreSums[n] + this.scorer.score();
                            continue block5;
                        }
                        case Min: {
                            this.scoreSums[termID] = Math.min(this.scoreSums[termID], this.scorer.score());
                            continue block5;
                        }
                        case Max: {
                            this.scoreSums[termID] = Math.max(this.scoreSums[termID], this.scorer.score());
                            continue block5;
                        }
                    }
                    throw new AssertionError((Object)("unexpected: " + (Object)((Object)this.scoreMode)));
                }
            }
        }

        static class Avg
        extends MV {
            int[] scoreCounts = new int[0];

            Avg(DocValuesTermsCollector.Function<SortedSetDocValues> docValuesCall) {
                super(docValuesCall, ScoreMode.Avg);
            }

            @Override
            public void collect(int doc) throws IOException {
                if (((SortedSetDocValues)this.docValues).advanceExact(doc)) {
                    long ord;
                    while ((ord = ((SortedSetDocValues)this.docValues).nextOrd()) != -1L) {
                        int termID = this.collectedTerms.add(((SortedSetDocValues)this.docValues).lookupOrd(ord));
                        if (termID < 0) {
                            termID = -termID - 1;
                        } else if (termID >= this.scoreSums.length) {
                            this.scoreSums = ArrayUtil.grow(this.scoreSums);
                            this.scoreCounts = ArrayUtil.grow(this.scoreCounts);
                        }
                        int n = termID;
                        this.scoreSums[n] = this.scoreSums[n] + this.scorer.score();
                        int n2 = termID;
                        this.scoreCounts[n2] = this.scoreCounts[n2] + 1;
                    }
                }
            }

            @Override
            public float[] getScoresPerTerm() {
                if (this.scoreCounts != null) {
                    for (int i = 0; i < this.scoreCounts.length; ++i) {
                        this.scoreSums[i] = this.scoreSums[i] / (float)this.scoreCounts[i];
                    }
                    this.scoreCounts = null;
                }
                return this.scoreSums;
            }
        }
    }

    static class SV
    extends TermsWithScoreCollector<BinaryDocValues> {
        SV(DocValuesTermsCollector.Function<BinaryDocValues> docValuesCall, ScoreMode scoreMode) {
            super(docValuesCall, scoreMode);
        }

        @Override
        public void collect(int doc) throws IOException {
            BytesRef value = ((BinaryDocValues)this.docValues).advanceExact(doc) ? ((BinaryDocValues)this.docValues).binaryValue() : new BytesRef(BytesRef.EMPTY_BYTES);
            int ord = this.collectedTerms.add(value);
            if (ord < 0) {
                ord = -ord - 1;
            } else if (ord >= this.scoreSums.length) {
                int begin = this.scoreSums.length;
                this.scoreSums = ArrayUtil.grow(this.scoreSums);
                if (this.scoreMode == ScoreMode.Min) {
                    Arrays.fill(this.scoreSums, begin, this.scoreSums.length, Float.POSITIVE_INFINITY);
                } else if (this.scoreMode == ScoreMode.Max) {
                    Arrays.fill(this.scoreSums, begin, this.scoreSums.length, Float.NEGATIVE_INFINITY);
                }
            }
            float current = this.scorer.score();
            float existing = this.scoreSums[ord];
            if (Float.compare(existing, 0.0f) == 0) {
                this.scoreSums[ord] = current;
            } else {
                switch (this.scoreMode) {
                    case Total: {
                        this.scoreSums[ord] = this.scoreSums[ord] + current;
                        break;
                    }
                    case Min: {
                        if (!(current < existing)) break;
                        this.scoreSums[ord] = current;
                        break;
                    }
                    case Max: {
                        if (!(current > existing)) break;
                        this.scoreSums[ord] = current;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("unexpected: " + (Object)((Object)this.scoreMode)));
                    }
                }
            }
        }

        static class Avg
        extends SV {
            int[] scoreCounts = new int[0];

            Avg(DocValuesTermsCollector.Function<BinaryDocValues> docValuesCall) {
                super(docValuesCall, ScoreMode.Avg);
            }

            @Override
            public void collect(int doc) throws IOException {
                BytesRef value = ((BinaryDocValues)this.docValues).advanceExact(doc) ? ((BinaryDocValues)this.docValues).binaryValue() : new BytesRef(BytesRef.EMPTY_BYTES);
                int ord = this.collectedTerms.add(value);
                if (ord < 0) {
                    ord = -ord - 1;
                } else if (ord >= this.scoreSums.length) {
                    this.scoreSums = ArrayUtil.grow(this.scoreSums);
                    this.scoreCounts = ArrayUtil.grow(this.scoreCounts);
                }
                float current = this.scorer.score();
                float existing = this.scoreSums[ord];
                if (Float.compare(existing, 0.0f) == 0) {
                    this.scoreSums[ord] = current;
                    this.scoreCounts[ord] = 1;
                } else {
                    this.scoreSums[ord] = this.scoreSums[ord] + current;
                    int n = ord;
                    this.scoreCounts[n] = this.scoreCounts[n] + 1;
                }
            }

            @Override
            public float[] getScoresPerTerm() {
                if (this.scoreCounts != null) {
                    for (int i = 0; i < this.scoreCounts.length; ++i) {
                        this.scoreSums[i] = this.scoreSums[i] / (float)this.scoreCounts[i];
                    }
                    this.scoreCounts = null;
                }
                return this.scoreSums;
            }
        }
    }
}

