/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.cluster.node.info;

import conductor.org.elasticsearch.action.FailedNodeException;
import conductor.org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import conductor.org.elasticsearch.action.support.nodes.BaseNodesResponse;
import conductor.org.elasticsearch.cluster.ClusterName;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentFragment;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentFactory;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class NodesInfoResponse
extends BaseNodesResponse<NodeInfo>
implements ToXContentFragment {
    public NodesInfoResponse() {
    }

    public NodesInfoResponse(ClusterName clusterName, List<NodeInfo> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
    }

    @Override
    protected List<NodeInfo> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(NodeInfo::readNodeInfo);
    }

    @Override
    protected void writeNodesTo(StreamOutput out, List<NodeInfo> nodes) throws IOException {
        out.writeStreamableList(nodes);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("nodes");
        for (NodeInfo nodeInfo : this.getNodes()) {
            builder.startObject(nodeInfo.getNode().getId());
            builder.field("name", nodeInfo.getNode().getName());
            builder.field("transport_address", nodeInfo.getNode().getAddress().toString());
            builder.field("host", nodeInfo.getNode().getHostName());
            builder.field("ip", nodeInfo.getNode().getHostAddress());
            builder.field("version", nodeInfo.getVersion());
            builder.field("build_flavor", nodeInfo.getBuild().flavor().displayName());
            builder.field("build_type", nodeInfo.getBuild().type().displayName());
            builder.field("build_hash", nodeInfo.getBuild().shortHash());
            if (nodeInfo.getTotalIndexingBuffer() != null) {
                builder.humanReadableField("total_indexing_buffer", "total_indexing_buffer_in_bytes", nodeInfo.getTotalIndexingBuffer());
            }
            builder.startArray("roles");
            for (DiscoveryNode.Role role : nodeInfo.getNode().getRoles()) {
                builder.value(role.getRoleName());
            }
            builder.endArray();
            if (!nodeInfo.getNode().getAttributes().isEmpty()) {
                builder.startObject("attributes");
                for (Map.Entry entry : nodeInfo.getNode().getAttributes().entrySet()) {
                    builder.field((String)entry.getKey(), (String)entry.getValue());
                }
                builder.endObject();
            }
            if (nodeInfo.getSettings() != null) {
                builder.startObject("settings");
                Settings settings = nodeInfo.getSettings();
                settings.toXContent(builder, params);
                builder.endObject();
            }
            if (nodeInfo.getOs() != null) {
                nodeInfo.getOs().toXContent(builder, params);
            }
            if (nodeInfo.getProcess() != null) {
                nodeInfo.getProcess().toXContent(builder, params);
            }
            if (nodeInfo.getJvm() != null) {
                nodeInfo.getJvm().toXContent(builder, params);
            }
            if (nodeInfo.getThreadPool() != null) {
                nodeInfo.getThreadPool().toXContent(builder, params);
            }
            if (nodeInfo.getTransport() != null) {
                nodeInfo.getTransport().toXContent(builder, params);
            }
            if (nodeInfo.getHttp() != null) {
                nodeInfo.getHttp().toXContent(builder, params);
            }
            if (nodeInfo.getPlugins() != null) {
                nodeInfo.getPlugins().toXContent(builder, params);
            }
            if (nodeInfo.getIngest() != null) {
                nodeInfo.getIngest().toXContent(builder, params);
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
            builder.startObject();
            this.toXContent(builder, EMPTY_PARAMS);
            builder.endObject();
            return Strings.toString(builder);
        }
        catch (IOException e) {
            return "{ \"error\" : \"" + e.getMessage() + "\"}";
        }
    }
}

