/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.cluster.snapshots.restore;

import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import conductor.org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.master.TransportMasterNodeAction;
import conductor.org.elasticsearch.cluster.ClusterChangedEvent;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.ClusterStateListener;
import conductor.org.elasticsearch.cluster.RestoreInProgress;
import conductor.org.elasticsearch.cluster.block.ClusterBlockException;
import conductor.org.elasticsearch.cluster.block.ClusterBlockLevel;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.collect.ImmutableOpenMap;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.snapshots.RestoreInfo;
import conductor.org.elasticsearch.snapshots.RestoreService;
import conductor.org.elasticsearch.snapshots.Snapshot;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;

public class TransportRestoreSnapshotAction
extends TransportMasterNodeAction<RestoreSnapshotRequest, RestoreSnapshotResponse> {
    private final RestoreService restoreService;

    @Inject
    public TransportRestoreSnapshotAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, RestoreService restoreService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:admin/snapshot/restore", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, RestoreSnapshotRequest::new);
        this.restoreService = restoreService;
    }

    @Override
    protected String executor() {
        return "snapshot";
    }

    @Override
    protected RestoreSnapshotResponse newResponse() {
        return new RestoreSnapshotResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(RestoreSnapshotRequest request, ClusterState state) {
        ClusterBlockException blockException = state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        if (blockException != null) {
            return blockException;
        }
        return state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
    }

    @Override
    protected void masterOperation(final RestoreSnapshotRequest request, ClusterState state, final ActionListener<RestoreSnapshotResponse> listener) {
        RestoreService.RestoreRequest restoreRequest = new RestoreService.RestoreRequest(request.repository(), request.snapshot(), request.indices(), request.indicesOptions(), request.renamePattern(), request.renameReplacement(), request.settings(), request.masterNodeTimeout(), request.includeGlobalState(), request.partial(), request.includeAliases(), request.indexSettings(), request.ignoreIndexSettings(), "restore_snapshot[" + request.snapshot() + "]");
        this.restoreService.restoreSnapshot(restoreRequest, new ActionListener<RestoreService.RestoreCompletionResponse>(){

            @Override
            public void onResponse(RestoreService.RestoreCompletionResponse restoreCompletionResponse) {
                if (restoreCompletionResponse.getRestoreInfo() == null && request.waitForCompletion()) {
                    final Snapshot snapshot = restoreCompletionResponse.getSnapshot();
                    ClusterStateListener clusterStateListener = new ClusterStateListener(){

                        @Override
                        public void clusterChanged(ClusterChangedEvent changedEvent) {
                            RestoreInProgress.Entry prevEntry = RestoreService.restoreInProgress(changedEvent.previousState(), snapshot);
                            RestoreInProgress.Entry newEntry = RestoreService.restoreInProgress(changedEvent.state(), snapshot);
                            if (prevEntry == null) {
                                TransportRestoreSnapshotAction.this.clusterService.removeListener(this);
                                listener.onResponse(new RestoreSnapshotResponse(null));
                            } else if (newEntry == null) {
                                TransportRestoreSnapshotAction.this.clusterService.removeListener(this);
                                ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards = prevEntry.shards();
                                assert (prevEntry.state().completed()) : "expected completed snapshot state but was " + (Object)((Object)prevEntry.state());
                                assert (RestoreService.completed(shards)) : "expected all restore entries to be completed";
                                RestoreInfo ri = new RestoreInfo(prevEntry.snapshot().getSnapshotId().getName(), prevEntry.indices(), shards.size(), shards.size() - RestoreService.failedShards(shards));
                                RestoreSnapshotResponse response = new RestoreSnapshotResponse(ri);
                                TransportRestoreSnapshotAction.this.logger.debug("restore of [{}] completed", (Object)snapshot);
                                listener.onResponse(response);
                            }
                        }
                    };
                    TransportRestoreSnapshotAction.this.clusterService.addListener(clusterStateListener);
                } else {
                    listener.onResponse(new RestoreSnapshotResponse(restoreCompletionResponse.getRestoreInfo()));
                }
            }

            @Override
            public void onFailure(Exception t) {
                listener.onFailure(t);
            }
        });
    }
}

