/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.indices.exists.types;

import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.admin.indices.exists.types.TypesExistsRequest;
import conductor.org.elasticsearch.action.admin.indices.exists.types.TypesExistsResponse;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.block.ClusterBlockException;
import conductor.org.elasticsearch.cluster.block.ClusterBlockLevel;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.metadata.MappingMetaData;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.collect.ImmutableOpenMap;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;

public class TransportTypesExistsAction
extends TransportMasterNodeReadAction<TypesExistsRequest, TypesExistsResponse> {
    @Inject
    public TransportTypesExistsAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:admin/types/exists", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, TypesExistsRequest::new);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected TypesExistsResponse newResponse() {
        return new TypesExistsResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(TypesExistsRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, this.indexNameExpressionResolver.concreteIndexNames(state, request));
    }

    @Override
    protected void masterOperation(TypesExistsRequest request, ClusterState state, ActionListener<TypesExistsResponse> listener) {
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(state, request.indicesOptions(), request.indices());
        if (concreteIndices.length == 0) {
            listener.onResponse(new TypesExistsResponse(false));
            return;
        }
        for (String concreteIndex : concreteIndices) {
            if (!state.metaData().hasConcreteIndex(concreteIndex)) {
                listener.onResponse(new TypesExistsResponse(false));
                return;
            }
            ImmutableOpenMap<String, MappingMetaData> mappings = state.metaData().getIndices().get(concreteIndex).getMappings();
            if (mappings.isEmpty()) {
                listener.onResponse(new TypesExistsResponse(false));
                return;
            }
            for (String type : request.types()) {
                if (mappings.containsKey(type)) continue;
                listener.onResponse(new TypesExistsResponse(false));
                return;
            }
        }
        listener.onResponse(new TypesExistsResponse(true));
    }
}

