/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.cluster;

import conductor.org.elasticsearch.cluster.Diff;
import conductor.org.elasticsearch.cluster.Diffable;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Writeable;
import java.io.IOException;

public abstract class AbstractDiffable<T extends Diffable<T>>
implements Diffable<T> {
    @Override
    public Diff<T> diff(T previousState) {
        if (this.get().equals(previousState)) {
            return new CompleteDiff();
        }
        return new CompleteDiff<T>(this.get());
    }

    public static <T extends Diffable<T>> Diff<T> readDiffFrom(Writeable.Reader<T> reader, StreamInput in) throws IOException {
        return new CompleteDiff<T>(reader, in);
    }

    public T get() {
        return (T)this;
    }

    private static class CompleteDiff<T extends Diffable<T>>
    implements Diff<T> {
        @Nullable
        private final T part;

        CompleteDiff(T part) {
            this.part = part;
        }

        CompleteDiff() {
            this.part = null;
        }

        CompleteDiff(Writeable.Reader<T> reader, StreamInput in) throws IOException {
            this.part = in.readBoolean() ? (Diffable)reader.read(in) : null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (this.part != null) {
                out.writeBoolean(true);
                this.part.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public T apply(T part) {
            if (this.part != null) {
                return this.part;
            }
            return part;
        }
    }
}

