/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.cluster.routing.allocation.decider;

import conductor.org.elasticsearch.cluster.metadata.IndexMetaData;
import conductor.org.elasticsearch.cluster.routing.RoutingNode;
import conductor.org.elasticsearch.cluster.routing.ShardRouting;
import conductor.org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import conductor.org.elasticsearch.cluster.routing.allocation.decider.Decision;
import conductor.org.elasticsearch.common.component.AbstractComponent;
import conductor.org.elasticsearch.common.settings.Settings;

public abstract class AllocationDecider
extends AbstractComponent {
    protected AllocationDecider(Settings settings) {
        super(settings);
    }

    public Decision canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        return Decision.ALWAYS;
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return Decision.ALWAYS;
    }

    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return Decision.ALWAYS;
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingAllocation allocation) {
        return Decision.ALWAYS;
    }

    public Decision canAllocate(IndexMetaData indexMetaData, RoutingNode node, RoutingAllocation allocation) {
        return Decision.ALWAYS;
    }

    public Decision canAllocate(RoutingNode node, RoutingAllocation allocation) {
        return Decision.ALWAYS;
    }

    public Decision canRebalance(RoutingAllocation allocation) {
        return Decision.ALWAYS;
    }

    public Decision canForceAllocatePrimary(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        assert (shardRouting.primary()) : "must not call canForceAllocatePrimary on a non-primary shard " + shardRouting;
        assert (shardRouting.unassigned()) : "must not call canForceAllocatePrimary on an assigned shard " + shardRouting;
        Decision decision = this.canAllocate(shardRouting, node, allocation);
        if (decision.type() == Decision.Type.NO) {
            return allocation.decision(Decision.YES, decision.label(), "primary shard [%s] allowed to force allocate on node [%s]", shardRouting.shardId(), node.nodeId());
        }
        return decision;
    }
}

