/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.transport;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Writeable;
import conductor.org.elasticsearch.common.network.NetworkAddress;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentFragment;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public final class TransportAddress
implements Writeable,
ToXContentFragment {
    public static final InetAddress META_ADDRESS;
    private final InetSocketAddress address;

    public TransportAddress(InetAddress address, int port) {
        this(new InetSocketAddress(address, port));
    }

    public TransportAddress(InetSocketAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("InetSocketAddress must not be null");
        }
        if (address.getAddress() == null) {
            throw new IllegalArgumentException("Address must be resolved but wasn't - InetSocketAddress#getAddress() returned null");
        }
        this.address = address;
    }

    public TransportAddress(StreamInput in) throws IOException {
        this(in, null);
    }

    public TransportAddress(StreamInput in, @Nullable String hostString) throws IOException {
        InetAddress inetAddress;
        short i;
        if (in.getVersion().before(Version.V_6_0_0_alpha1) && (i = in.readShort()) != 1) {
            throw new AssertionError((Object)("illegal transport ID from node of version: " + in.getVersion() + " got: " + i + " expected: 1"));
        }
        byte len = in.readByte();
        byte[] a = new byte[len];
        in.readFully(a);
        if (in.getVersion().after(Version.V_5_0_2)) {
            String host = in.readString();
            inetAddress = InetAddress.getByAddress(host, a);
        } else {
            inetAddress = InetAddress.getByAddress(hostString, a);
        }
        int port = in.readInt();
        this.address = new InetSocketAddress(inetAddress, port);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().before(Version.V_6_0_0_alpha1)) {
            out.writeShort((short)1);
        }
        byte[] bytes = this.address.getAddress().getAddress();
        out.writeByte((byte)bytes.length);
        out.write(bytes, 0, bytes.length);
        if (out.getVersion().after(Version.V_5_0_2)) {
            out.writeString(this.address.getHostString());
        }
        out.writeInt(this.address.getPort());
    }

    public String getAddress() {
        return NetworkAddress.format(this.address.getAddress());
    }

    public int getPort() {
        return this.address.getPort();
    }

    public InetSocketAddress address() {
        return this.address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransportAddress address1 = (TransportAddress)o;
        return this.address.equals(address1.address);
    }

    public int hashCode() {
        return this.address != null ? this.address.hashCode() : 0;
    }

    public String toString() {
        return NetworkAddress.format(this.address);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.toString());
    }

    static {
        try {
            META_ADDRESS = InetAddress.getByName("0.0.0.0");
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)e);
        }
    }
}

