/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.gateway;

import conductor.org.apache.logging.log4j.message.ParameterizedMessage;
import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.FailedNodeException;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.nodes.BaseNodeRequest;
import conductor.org.elasticsearch.action.support.nodes.BaseNodeResponse;
import conductor.org.elasticsearch.action.support.nodes.BaseNodesRequest;
import conductor.org.elasticsearch.action.support.nodes.BaseNodesResponse;
import conductor.org.elasticsearch.action.support.nodes.TransportNodesAction;
import conductor.org.elasticsearch.cluster.ClusterName;
import conductor.org.elasticsearch.cluster.metadata.IndexMetaData;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import conductor.org.elasticsearch.env.NodeEnvironment;
import conductor.org.elasticsearch.gateway.AsyncShardFetch;
import conductor.org.elasticsearch.index.IndexSettings;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.index.shard.ShardPath;
import conductor.org.elasticsearch.index.shard.ShardStateMetaData;
import conductor.org.elasticsearch.index.store.Store;
import conductor.org.elasticsearch.indices.IndicesService;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;
import java.io.IOException;
import java.util.List;

public class TransportNodesListGatewayStartedShards
extends TransportNodesAction<Request, NodesGatewayStartedShards, NodeRequest, NodeGatewayStartedShards>
implements AsyncShardFetch.Lister<NodesGatewayStartedShards, NodeGatewayStartedShards> {
    public static final String ACTION_NAME = "internal:gateway/local/started_shards";
    private final NodeEnvironment nodeEnv;
    private final IndicesService indicesService;
    private final NamedXContentRegistry namedXContentRegistry;

    @Inject
    public TransportNodesListGatewayStartedShards(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NodeEnvironment env, IndicesService indicesService, NamedXContentRegistry namedXContentRegistry) {
        super(settings, ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, Request::new, NodeRequest::new, "fetch_shard_started", NodeGatewayStartedShards.class);
        this.nodeEnv = env;
        this.indicesService = indicesService;
        this.namedXContentRegistry = namedXContentRegistry;
    }

    @Override
    public void list(ShardId shardId, DiscoveryNode[] nodes, ActionListener<NodesGatewayStartedShards> listener) {
        this.execute(new Request(shardId, nodes), listener);
    }

    @Override
    protected boolean transportCompress() {
        return true;
    }

    @Override
    protected NodeRequest newNodeRequest(String nodeId, Request request) {
        return new NodeRequest(nodeId, request);
    }

    @Override
    protected NodeGatewayStartedShards newNodeResponse() {
        return new NodeGatewayStartedShards();
    }

    @Override
    protected NodesGatewayStartedShards newResponse(Request request, List<NodeGatewayStartedShards> responses, List<FailedNodeException> failures) {
        return new NodesGatewayStartedShards(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeGatewayStartedShards nodeOperation(NodeRequest request) {
        try {
            ShardId shardId = request.getShardId();
            this.logger.trace("{} loading local shard state info", (Object)shardId);
            ShardStateMetaData shardStateMetaData = ShardStateMetaData.FORMAT.loadLatestState(this.logger, this.namedXContentRegistry, this.nodeEnv.availableShardPaths(request.shardId));
            if (shardStateMetaData != null) {
                IndexMetaData metaData = this.clusterService.state().metaData().index(shardId.getIndex());
                if (metaData == null) {
                    metaData = IndexMetaData.FORMAT.loadLatestState(this.logger, this.namedXContentRegistry, this.nodeEnv.indexPaths(shardId.getIndex()));
                }
                if (metaData == null) {
                    ElasticsearchException e = new ElasticsearchException("failed to find local IndexMetaData", new Object[0]);
                    e.setShard(request.shardId);
                    throw e;
                }
                if (this.indicesService.getShardOrNull(shardId) == null) {
                    ShardPath shardPath = null;
                    try {
                        IndexSettings indexSettings = new IndexSettings(metaData, this.settings);
                        shardPath = ShardPath.loadShardPath(this.logger, this.nodeEnv, shardId, indexSettings);
                        if (shardPath == null) {
                            throw new IllegalStateException(shardId + " no shard path found");
                        }
                        Store.tryOpenIndex(shardPath.resolveIndex(), shardId, this.nodeEnv::shardLock, this.logger);
                    }
                    catch (Exception exception) {
                        ShardPath finalShardPath = shardPath;
                        this.logger.trace(() -> new ParameterizedMessage("{} can't open index for shard [{}] in path [{}]", shardId, shardStateMetaData, finalShardPath != null ? finalShardPath.resolveIndex() : ""), (Throwable)exception);
                        String allocationId = shardStateMetaData.allocationId != null ? shardStateMetaData.allocationId.getId() : null;
                        return new NodeGatewayStartedShards(this.clusterService.localNode(), allocationId, shardStateMetaData.primary, exception);
                    }
                }
                this.logger.debug("{} shard state info found: [{}]", (Object)shardId, (Object)shardStateMetaData);
                String allocationId = shardStateMetaData.allocationId != null ? shardStateMetaData.allocationId.getId() : null;
                return new NodeGatewayStartedShards(this.clusterService.localNode(), allocationId, shardStateMetaData.primary);
            }
            this.logger.trace("{} no local shard info found", (Object)shardId);
            return new NodeGatewayStartedShards(this.clusterService.localNode(), null, false);
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to load started shards", (Throwable)e, new Object[0]);
        }
    }

    public static class NodeGatewayStartedShards
    extends BaseNodeResponse {
        private String allocationId = null;
        private boolean primary = false;
        private Exception storeException = null;

        public NodeGatewayStartedShards() {
        }

        public NodeGatewayStartedShards(DiscoveryNode node, String allocationId, boolean primary) {
            this(node, allocationId, primary, null);
        }

        public NodeGatewayStartedShards(DiscoveryNode node, String allocationId, boolean primary, Exception storeException) {
            super(node);
            this.allocationId = allocationId;
            this.primary = primary;
            this.storeException = storeException;
        }

        public String allocationId() {
            return this.allocationId;
        }

        public boolean primary() {
            return this.primary;
        }

        public Exception storeException() {
            return this.storeException;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            if (in.getVersion().before(Version.V_6_0_0_alpha1)) {
                in.readLong();
            }
            this.allocationId = in.readOptionalString();
            this.primary = in.readBoolean();
            if (in.readBoolean()) {
                this.storeException = in.readException();
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (out.getVersion().before(Version.V_6_0_0_alpha1)) {
                out.writeLong(-1L);
            }
            out.writeOptionalString(this.allocationId);
            out.writeBoolean(this.primary);
            if (this.storeException != null) {
                out.writeBoolean(true);
                out.writeException(this.storeException);
            } else {
                out.writeBoolean(false);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeGatewayStartedShards that = (NodeGatewayStartedShards)o;
            if (this.primary != that.primary) {
                return false;
            }
            if (this.allocationId != null ? !this.allocationId.equals(that.allocationId) : that.allocationId != null) {
                return false;
            }
            return this.storeException != null ? this.storeException.equals(that.storeException) : that.storeException == null;
        }

        public int hashCode() {
            int result = this.allocationId != null ? this.allocationId.hashCode() : 0;
            result = 31 * result + (this.primary ? 1 : 0);
            result = 31 * result + (this.storeException != null ? this.storeException.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("NodeGatewayStartedShards[").append("allocationId=").append(this.allocationId).append(",primary=").append(this.primary);
            if (this.storeException != null) {
                buf.append(",storeException=").append(this.storeException);
            }
            buf.append("]");
            return buf.toString();
        }
    }

    public static class NodeRequest
    extends BaseNodeRequest {
        private ShardId shardId;

        public NodeRequest() {
        }

        public NodeRequest(String nodeId, Request request) {
            super(nodeId);
            this.shardId = request.shardId();
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.shardId = ShardId.readShardId(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
        }

        public ShardId getShardId() {
            return this.shardId;
        }
    }

    public static class NodesGatewayStartedShards
    extends BaseNodesResponse<NodeGatewayStartedShards> {
        public NodesGatewayStartedShards(ClusterName clusterName, List<NodeGatewayStartedShards> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        @Override
        protected List<NodeGatewayStartedShards> readNodesFrom(StreamInput in) throws IOException {
            return in.readStreamableList(NodeGatewayStartedShards::new);
        }

        @Override
        protected void writeNodesTo(StreamOutput out, List<NodeGatewayStartedShards> nodes) throws IOException {
            out.writeStreamableList(nodes);
        }
    }

    public static class Request
    extends BaseNodesRequest<Request> {
        private ShardId shardId;

        public Request() {
        }

        public Request(ShardId shardId, DiscoveryNode[] nodes) {
            super(nodes);
            this.shardId = shardId;
        }

        public ShardId shardId() {
            return this.shardId;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.shardId = ShardId.readShardId(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
        }
    }
}

