/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.fielddata.fieldcomparator;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.NumericDocValues;
import conductor.org.apache.lucene.search.DocIdSetIterator;
import conductor.org.apache.lucene.search.FieldComparator;
import conductor.org.apache.lucene.search.Scorer;
import conductor.org.apache.lucene.search.SortField;
import conductor.org.apache.lucene.util.BitSet;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import conductor.org.elasticsearch.index.fielddata.FieldData;
import conductor.org.elasticsearch.index.fielddata.IndexFieldData;
import conductor.org.elasticsearch.index.fielddata.IndexNumericFieldData;
import conductor.org.elasticsearch.index.fielddata.NumericDoubleValues;
import conductor.org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import conductor.org.elasticsearch.search.MultiValueMode;
import java.io.IOException;

public class DoubleValuesComparatorSource
extends IndexFieldData.XFieldComparatorSource {
    private final IndexNumericFieldData indexFieldData;

    public DoubleValuesComparatorSource(IndexNumericFieldData indexFieldData, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        super(missingValue, sortMode, nested);
        this.indexFieldData = indexFieldData;
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.DOUBLE;
    }

    protected SortedNumericDoubleValues getValues(LeafReaderContext context) throws IOException {
        return ((AtomicNumericFieldData)this.indexFieldData.load(context)).getDoubleValues();
    }

    protected void setScorer(Scorer scorer) {
    }

    @Override
    public FieldComparator<?> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) {
        assert (this.indexFieldData == null || fieldname.equals(this.indexFieldData.getFieldName()));
        final double dMissingValue = (Double)this.missingObject(this.missingValue, reversed);
        return new FieldComparator.DoubleComparator(numHits, null, null){

            @Override
            protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                NumericDoubleValues selectedValues;
                SortedNumericDoubleValues values = DoubleValuesComparatorSource.this.getValues(context);
                if (DoubleValuesComparatorSource.this.nested == null) {
                    selectedValues = FieldData.replaceMissing(DoubleValuesComparatorSource.this.sortMode.select(values), dMissingValue);
                } else {
                    BitSet rootDocs = DoubleValuesComparatorSource.this.nested.rootDocs(context);
                    DocIdSetIterator innerDocs = DoubleValuesComparatorSource.this.nested.innerDocs(context);
                    int maxChildren = DoubleValuesComparatorSource.this.nested.getNestedSort() != null ? DoubleValuesComparatorSource.this.nested.getNestedSort().getMaxChildren() : Integer.MAX_VALUE;
                    selectedValues = DoubleValuesComparatorSource.this.sortMode.select(values, dMissingValue, rootDocs, innerDocs, context.reader().maxDoc(), maxChildren);
                }
                return selectedValues.getRawDoubleValues();
            }

            @Override
            public void setScorer(Scorer scorer) {
                DoubleValuesComparatorSource.this.setScorer(scorer);
            }
        };
    }
}

