/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.ingest;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Writeable;
import conductor.org.elasticsearch.common.unit.TimeValue;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentFragment;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.ingest.IngestMetric;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class IngestStats
implements Writeable,
ToXContentFragment {
    private final Stats totalStats;
    private final List<PipelineStat> pipelineStats;
    private final Map<String, List<ProcessorStat>> processorStats;

    public IngestStats(Stats totalStats, List<PipelineStat> pipelineStats, Map<String, List<ProcessorStat>> processorStats) {
        this.totalStats = totalStats;
        this.pipelineStats = pipelineStats;
        this.processorStats = processorStats;
    }

    public IngestStats(StreamInput in) throws IOException {
        this.totalStats = new Stats(in);
        int size = in.readVInt();
        this.pipelineStats = new ArrayList<PipelineStat>(size);
        this.processorStats = new HashMap<String, List<ProcessorStat>>(size);
        for (int i = 0; i < size; ++i) {
            String pipelineId = in.readString();
            Stats pipelineStat = new Stats(in);
            this.pipelineStats.add(new PipelineStat(pipelineId, pipelineStat));
            if (!in.getVersion().onOrAfter(Version.V_6_5_0)) continue;
            int processorsSize = in.readVInt();
            ArrayList<ProcessorStat> processorStatsPerPipeline = new ArrayList<ProcessorStat>(processorsSize);
            for (int j = 0; j < processorsSize; ++j) {
                String processorName = in.readString();
                Stats processorStat = new Stats(in);
                processorStatsPerPipeline.add(new ProcessorStat(processorName, processorStat));
            }
            this.processorStats.put(pipelineId, processorStatsPerPipeline);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.totalStats.writeTo(out);
        out.writeVInt(this.pipelineStats.size());
        for (PipelineStat pipelineStat : this.pipelineStats) {
            out.writeString(pipelineStat.getPipelineId());
            pipelineStat.getStats().writeTo(out);
            if (!out.getVersion().onOrAfter(Version.V_6_5_0)) continue;
            List<ProcessorStat> processorStatsForPipeline = this.processorStats.get(pipelineStat.getPipelineId());
            if (processorStatsForPipeline == null) {
                out.writeVInt(0);
                continue;
            }
            out.writeVInt(processorStatsForPipeline.size());
            for (ProcessorStat processorStat : processorStatsForPipeline) {
                out.writeString(processorStat.getName());
                processorStat.getStats().writeTo(out);
            }
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("ingest");
        builder.startObject("total");
        this.totalStats.toXContent(builder, params);
        builder.endObject();
        builder.startObject("pipelines");
        for (PipelineStat pipelineStat : this.pipelineStats) {
            builder.startObject(pipelineStat.getPipelineId());
            pipelineStat.getStats().toXContent(builder, params);
            List<ProcessorStat> processorStatsForPipeline = this.processorStats.get(pipelineStat.getPipelineId());
            builder.startArray("processors");
            if (processorStatsForPipeline != null) {
                for (ProcessorStat processorStat : processorStatsForPipeline) {
                    builder.startObject();
                    builder.startObject(processorStat.getName());
                    processorStat.getStats().toXContent(builder, params);
                    builder.endObject();
                    builder.endObject();
                }
            }
            builder.endArray();
            builder.endObject();
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public Stats getTotalStats() {
        return this.totalStats;
    }

    public List<PipelineStat> getPipelineStats() {
        return this.pipelineStats;
    }

    public Map<String, List<ProcessorStat>> getProcessorStats() {
        return this.processorStats;
    }

    public static class ProcessorStat {
        private final String name;
        private final Stats stats;

        public ProcessorStat(String name, Stats stats) {
            this.name = name;
            this.stats = stats;
        }

        public String getName() {
            return this.name;
        }

        public Stats getStats() {
            return this.stats;
        }
    }

    public static class PipelineStat {
        private final String pipelineId;
        private final Stats stats;

        public PipelineStat(String pipelineId, Stats stats) {
            this.pipelineId = pipelineId;
            this.stats = stats;
        }

        public String getPipelineId() {
            return this.pipelineId;
        }

        public Stats getStats() {
            return this.stats;
        }
    }

    static class Builder {
        private Stats totalStats;
        private List<PipelineStat> pipelineStats = new ArrayList<PipelineStat>();
        private Map<String, List<ProcessorStat>> processorStats = new HashMap<String, List<ProcessorStat>>();

        Builder() {
        }

        Builder addTotalMetrics(IngestMetric totalMetric) {
            this.totalStats = totalMetric.createStats();
            return this;
        }

        Builder addPipelineMetrics(String pipelineId, IngestMetric pipelineMetric) {
            this.pipelineStats.add(new PipelineStat(pipelineId, pipelineMetric.createStats()));
            return this;
        }

        Builder addProcessorMetrics(String pipelineId, String processorName, IngestMetric metric) {
            this.processorStats.computeIfAbsent(pipelineId, k -> new ArrayList()).add(new ProcessorStat(processorName, metric.createStats()));
            return this;
        }

        IngestStats build() {
            return new IngestStats(this.totalStats, Collections.unmodifiableList(this.pipelineStats), Collections.unmodifiableMap(this.processorStats));
        }
    }

    public static class Stats
    implements Writeable,
    ToXContentFragment {
        private final long ingestCount;
        private final long ingestTimeInMillis;
        private final long ingestCurrent;
        private final long ingestFailedCount;

        public Stats(long ingestCount, long ingestTimeInMillis, long ingestCurrent, long ingestFailedCount) {
            this.ingestCount = ingestCount;
            this.ingestTimeInMillis = ingestTimeInMillis;
            this.ingestCurrent = ingestCurrent;
            this.ingestFailedCount = ingestFailedCount;
        }

        public Stats(StreamInput in) throws IOException {
            this.ingestCount = in.readVLong();
            this.ingestTimeInMillis = in.readVLong();
            this.ingestCurrent = in.readVLong();
            this.ingestFailedCount = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.ingestCount);
            out.writeVLong(this.ingestTimeInMillis);
            out.writeVLong(this.ingestCurrent);
            out.writeVLong(this.ingestFailedCount);
        }

        public long getIngestCount() {
            return this.ingestCount;
        }

        public long getIngestTimeInMillis() {
            return this.ingestTimeInMillis;
        }

        public long getIngestCurrent() {
            return this.ingestCurrent;
        }

        public long getIngestFailedCount() {
            return this.ingestFailedCount;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("count", this.ingestCount);
            builder.humanReadableField("time_in_millis", "time", new TimeValue(this.ingestTimeInMillis, TimeUnit.MILLISECONDS));
            builder.field("current", this.ingestCurrent);
            builder.field("failed", this.ingestFailedCount);
            return builder;
        }
    }
}

