/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.pipeline.derivative;

import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.ParsingException;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.rounding.DateTimeUnit;
import conductor.org.elasticsearch.common.unit.TimeValue;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.search.DocValueFormat;
import conductor.org.elasticsearch.search.aggregations.AggregationBuilder;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactory;
import conductor.org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import conductor.org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import conductor.org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregatorFactory;
import conductor.org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import conductor.org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregatorFactory;
import conductor.org.elasticsearch.search.aggregations.pipeline.AbstractPipelineAggregationBuilder;
import conductor.org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import conductor.org.elasticsearch.search.aggregations.pipeline.derivative.DerivativePipelineAggregator;
import conductor.org.joda.time.DateTimeZone;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public class DerivativePipelineAggregationBuilder
extends AbstractPipelineAggregationBuilder<DerivativePipelineAggregationBuilder> {
    public static final String NAME = "derivative";
    private static final ParseField FORMAT_FIELD = new ParseField("format", new String[0]);
    private static final ParseField GAP_POLICY_FIELD = new ParseField("gap_policy", new String[0]);
    private static final ParseField UNIT_FIELD = new ParseField("unit", new String[0]);
    private String format;
    private BucketHelpers.GapPolicy gapPolicy = BucketHelpers.GapPolicy.SKIP;
    private String units;

    public DerivativePipelineAggregationBuilder(String name, String bucketsPath) {
        this(name, new String[]{bucketsPath});
    }

    private DerivativePipelineAggregationBuilder(String name, String[] bucketsPaths) {
        super(name, NAME, bucketsPaths);
    }

    public DerivativePipelineAggregationBuilder(StreamInput in) throws IOException {
        super(in, NAME);
        this.format = in.readOptionalString();
        if (in.readBoolean()) {
            this.gapPolicy = BucketHelpers.GapPolicy.readFrom(in);
        }
        this.units = in.readOptionalString();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.format);
        boolean hasGapPolicy = this.gapPolicy != null;
        out.writeBoolean(hasGapPolicy);
        if (hasGapPolicy) {
            this.gapPolicy.writeTo(out);
        }
        out.writeOptionalString(this.units);
    }

    public DerivativePipelineAggregationBuilder format(String format) {
        if (format == null) {
            throw new IllegalArgumentException("[format] must not be null: [" + this.name + "]");
        }
        this.format = format;
        return this;
    }

    public String format() {
        return this.format;
    }

    public DerivativePipelineAggregationBuilder gapPolicy(BucketHelpers.GapPolicy gapPolicy) {
        if (gapPolicy == null) {
            throw new IllegalArgumentException("[gapPolicy] must not be null: [" + this.name + "]");
        }
        this.gapPolicy = gapPolicy;
        return this;
    }

    public BucketHelpers.GapPolicy gapPolicy() {
        return this.gapPolicy;
    }

    public DerivativePipelineAggregationBuilder unit(String units) {
        if (units == null) {
            throw new IllegalArgumentException("[units] must not be null: [" + this.name + "]");
        }
        this.units = units;
        return this;
    }

    public DerivativePipelineAggregationBuilder unit(DateHistogramInterval units) {
        if (units == null) {
            throw new IllegalArgumentException("[units] must not be null: [" + this.name + "]");
        }
        this.units = units.toString();
        return this;
    }

    public String unit() {
        return this.units;
    }

    @Override
    protected PipelineAggregator createInternal(Map<String, Object> metaData) throws IOException {
        DocValueFormat formatter = this.format != null ? new DocValueFormat.Decimal(this.format) : DocValueFormat.RAW;
        Long xAxisUnits = null;
        if (this.units != null) {
            DateTimeUnit dateTimeUnit = DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(this.units);
            if (dateTimeUnit != null) {
                xAxisUnits = dateTimeUnit.field(DateTimeZone.UTC).getDurationField().getUnitMillis();
            } else {
                TimeValue timeValue = TimeValue.parseTimeValue(this.units, null, this.getClass().getSimpleName() + ".unit");
                if (timeValue != null) {
                    xAxisUnits = timeValue.getMillis();
                }
            }
        }
        return new DerivativePipelineAggregator(this.name, this.bucketsPaths, formatter, this.gapPolicy, xAxisUnits, metaData);
    }

    @Override
    public void doValidate(AggregatorFactory<?> parent, Collection<AggregationBuilder> aggFactories, Collection<PipelineAggregationBuilder> pipelineAggregatoractories) {
        if (this.bucketsPaths.length != 1) {
            throw new IllegalStateException(PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName() + " must contain a single entry for aggregation [" + this.name + "]");
        }
        if (parent instanceof HistogramAggregatorFactory) {
            HistogramAggregatorFactory histoParent = (HistogramAggregatorFactory)parent;
            if (histoParent.minDocCount() != 0L) {
                throw new IllegalStateException("parent histogram of derivative aggregation [" + this.name + "] must have min_doc_count of 0");
            }
        } else if (parent instanceof DateHistogramAggregatorFactory) {
            DateHistogramAggregatorFactory histoParent = (DateHistogramAggregatorFactory)parent;
            if (histoParent.minDocCount() != 0L) {
                throw new IllegalStateException("parent histogram of derivative aggregation [" + this.name + "] must have min_doc_count of 0");
            }
        } else {
            throw new IllegalStateException("derivative aggregation [" + this.name + "] must have a histogram or date_histogram as parent");
        }
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.format != null) {
            builder.field(FORMAT_FIELD.getPreferredName(), this.format);
        }
        if (this.gapPolicy != null) {
            builder.field(GAP_POLICY_FIELD.getPreferredName(), this.gapPolicy.getName());
        }
        if (this.units != null) {
            builder.field(UNIT_FIELD.getPreferredName(), this.units);
        }
        return builder;
    }

    public static DerivativePipelineAggregationBuilder parse(String pipelineAggregatorName, XContentParser parser) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        String[] bucketsPaths = null;
        String format = null;
        String units = null;
        BucketHelpers.GapPolicy gapPolicy = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (FORMAT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    format = parser.text();
                    continue;
                }
                if (BUCKETS_PATH_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    bucketsPaths = new String[]{parser.text()};
                    continue;
                }
                if (GAP_POLICY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    gapPolicy = BucketHelpers.GapPolicy.parse(parser.text(), parser.getTokenLocation());
                    continue;
                }
                if (UNIT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    units = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + (Object)((Object)token) + " in [" + pipelineAggregatorName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (BUCKETS_PATH_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    ArrayList<String> paths = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        String path = parser.text();
                        paths.add(path);
                    }
                    bucketsPaths = paths.toArray(new String[paths.size()]);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + (Object)((Object)token) + " in [" + pipelineAggregatorName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + (Object)((Object)token) + " in [" + pipelineAggregatorName + "].", new Object[0]);
        }
        if (bucketsPaths == null) {
            throw new ParsingException(parser.getTokenLocation(), "Missing required field [" + BUCKETS_PATH_FIELD.getPreferredName() + "] for derivative aggregation [" + pipelineAggregatorName + "]", new Object[0]);
        }
        DerivativePipelineAggregationBuilder factory = new DerivativePipelineAggregationBuilder(pipelineAggregatorName, (String)bucketsPaths[0]);
        if (format != null) {
            factory.format(format);
        }
        if (gapPolicy != null) {
            factory.gapPolicy(gapPolicy);
        }
        if (units != null) {
            factory.unit(units);
        }
        return factory;
    }

    @Override
    protected boolean doEquals(Object obj) {
        DerivativePipelineAggregationBuilder other = (DerivativePipelineAggregationBuilder)obj;
        if (!Objects.equals(this.format, other.format)) {
            return false;
        }
        if (!Objects.equals((Object)this.gapPolicy, (Object)other.gapPolicy)) {
            return false;
        }
        return Objects.equals(this.units, other.units);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(new Object[]{this.format, this.gapPolicy, this.units});
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

