/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.tasks;

import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentHelper;
import conductor.org.elasticsearch.tasks.Task;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public class RawTaskStatus
implements Task.Status {
    public static final String NAME = "raw";
    private final BytesReference status;

    public RawTaskStatus(BytesReference status) {
        this.status = Objects.requireNonNull(status, "status may not be null");
    }

    public RawTaskStatus(StreamInput in) throws IOException {
        this.status = in.readOptionalBytesReference();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalBytesReference(this.status);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        try (StreamInput stream = this.status.streamInput();){
            XContentBuilder xContentBuilder = builder.rawValue(stream, XContentHelper.xContentType(this.status));
            return xContentBuilder;
        }
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    public String toString() {
        return Strings.toString(this);
    }

    public Map<String, Object> toMap() {
        return XContentHelper.convertToMap(this.status, false).v2();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != RawTaskStatus.class) {
            return false;
        }
        RawTaskStatus other = (RawTaskStatus)obj;
        return this.toMap().equals(other.toMap());
    }

    public int hashCode() {
        return this.toMap().hashCode();
    }
}

