/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.spatial3d.geom;

import conductor.org.apache.lucene.spatial3d.geom.GeoDegeneratePath;
import conductor.org.apache.lucene.spatial3d.geom.GeoPath;
import conductor.org.apache.lucene.spatial3d.geom.GeoPoint;
import conductor.org.apache.lucene.spatial3d.geom.GeoStandardPath;
import conductor.org.apache.lucene.spatial3d.geom.PlanetModel;
import java.util.ArrayList;

public class GeoPathFactory {
    private GeoPathFactory() {
    }

    public static GeoPath makeGeoPath(PlanetModel planetModel, double maxCutoffAngle, GeoPoint[] pathPoints) {
        if (maxCutoffAngle < 3.141592653589793E-12) {
            return new GeoDegeneratePath(planetModel, GeoPathFactory.filterPoints(pathPoints));
        }
        return new GeoStandardPath(planetModel, maxCutoffAngle, GeoPathFactory.filterPoints(pathPoints));
    }

    private static GeoPoint[] filterPoints(GeoPoint[] pathPoints) {
        ArrayList<GeoPoint> noIdenticalPoints = new ArrayList<GeoPoint>(pathPoints.length);
        for (int i = 0; i < pathPoints.length - 1; ++i) {
            if (pathPoints[i].isNumericallyIdentical(pathPoints[i + 1])) continue;
            noIdenticalPoints.add(pathPoints[i]);
        }
        noIdenticalPoints.add(pathPoints[pathPoints.length - 1]);
        return noIdenticalPoints.toArray(new GeoPoint[noIdenticalPoints.size()]);
    }
}

