/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.cluster.repositories.get;

import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesRequest;
import conductor.org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesResponse;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.block.ClusterBlockException;
import conductor.org.elasticsearch.cluster.block.ClusterBlockLevel;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.metadata.MetaData;
import conductor.org.elasticsearch.cluster.metadata.RepositoriesMetaData;
import conductor.org.elasticsearch.cluster.metadata.RepositoryMetaData;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.regex.Regex;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.repositories.RepositoryMissingException;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;

public class TransportGetRepositoriesAction
extends TransportMasterNodeReadAction<GetRepositoriesRequest, GetRepositoriesResponse> {
    @Inject
    public TransportGetRepositoriesAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:admin/repository/get", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, GetRepositoriesRequest::new);
    }

    @Override
    protected String executor() {
        return "management";
    }

    @Override
    protected GetRepositoriesResponse newResponse() {
        return new GetRepositoriesResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(GetRepositoriesRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected void masterOperation(GetRepositoriesRequest request, ClusterState state, ActionListener<GetRepositoriesResponse> listener) {
        MetaData metaData = state.metaData();
        RepositoriesMetaData repositories = (RepositoriesMetaData)metaData.custom("repositories");
        if (request.repositories().length == 0 || request.repositories().length == 1 && "_all".equals(request.repositories()[0])) {
            if (repositories != null) {
                listener.onResponse(new GetRepositoriesResponse(repositories));
            } else {
                listener.onResponse(new GetRepositoriesResponse(new RepositoriesMetaData(Collections.emptyList())));
            }
        } else if (repositories != null) {
            LinkedHashSet<String> repositoriesToGet = new LinkedHashSet<String>();
            for (String repositoryOrPattern : request.repositories()) {
                if (!Regex.isSimpleMatchPattern(repositoryOrPattern)) {
                    repositoriesToGet.add(repositoryOrPattern);
                    continue;
                }
                for (RepositoryMetaData repository : repositories.repositories()) {
                    if (!Regex.simpleMatch(repositoryOrPattern, repository.name())) continue;
                    repositoriesToGet.add(repository.name());
                }
            }
            ArrayList<RepositoryMetaData> repositoryListBuilder = new ArrayList<RepositoryMetaData>();
            for (String repository : repositoriesToGet) {
                RepositoryMetaData repositoryMetaData = repositories.repository(repository);
                if (repositoryMetaData == null) {
                    listener.onFailure(new RepositoryMissingException(repository));
                    return;
                }
                repositoryListBuilder.add(repositoryMetaData);
            }
            listener.onResponse(new GetRepositoriesResponse(new RepositoriesMetaData(repositoryListBuilder)));
        } else {
            listener.onFailure(new RepositoryMissingException(request.repositories()[0]));
        }
    }
}

