/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.cluster.repositories.verify;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.action.ActionResponse;
import conductor.org.elasticsearch.cluster.ClusterName;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Writeable;
import conductor.org.elasticsearch.common.transport.TransportAddress;
import conductor.org.elasticsearch.common.xcontent.ObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentObject;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class VerifyRepositoryResponse
extends ActionResponse
implements ToXContentObject {
    static final String NODES = "nodes";
    static final String NAME = "name";
    private List<DiscoveryNode> nodes;
    private ClusterName clusterName;
    private static final ObjectParser<VerifyRepositoryResponse, Void> PARSER = new ObjectParser(VerifyRepositoryResponse.class.getName(), VerifyRepositoryResponse::new);

    VerifyRepositoryResponse() {
    }

    public VerifyRepositoryResponse(ClusterName clusterName, DiscoveryNode[] nodes) {
        this.clusterName = clusterName;
        this.nodes = Arrays.asList(nodes);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        if (in.getVersion().onOrAfter(Version.V_6_4_0)) {
            this.nodes = in.readList(NodeView::new).stream().map(n -> n.convertToDiscoveryNode()).collect(Collectors.toList());
        } else {
            this.clusterName = new ClusterName(in);
            this.nodes = in.readList(DiscoveryNode::new);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
            out.writeList(this.getNodes());
        } else {
            this.clusterName.writeTo(out);
            out.writeList(this.nodes);
        }
    }

    public List<NodeView> getNodes() {
        return this.nodes.stream().map(dn -> new NodeView(dn.getId(), dn.getName())).collect(Collectors.toList());
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    protected void setNodes(List<NodeView> nodes) {
        this.nodes = nodes.stream().map(n -> n.convertToDiscoveryNode()).collect(Collectors.toList());
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(NODES);
        for (DiscoveryNode node : this.nodes) {
            builder.startObject(node.getId());
            builder.field(NAME, node.getName());
            builder.endObject();
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static VerifyRepositoryResponse fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public String toString() {
        return Strings.toString(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VerifyRepositoryResponse other = (VerifyRepositoryResponse)obj;
        return this.nodes.equals(other.nodes);
    }

    public int hashCode() {
        return this.nodes.hashCode();
    }

    static {
        PARSER.declareNamedObjects(VerifyRepositoryResponse::setNodes, NodeView.PARSER, new ParseField(NODES, new String[0]));
    }

    public static class NodeView
    implements Writeable,
    ToXContentObject {
        private static final ObjectParser.NamedObjectParser<NodeView, Void> PARSER;
        final String nodeId;
        String name;

        public NodeView(String nodeId) {
            this.nodeId = nodeId;
        }

        public NodeView(String nodeId, String name) {
            this(nodeId);
            this.name = name;
        }

        public NodeView(StreamInput in) throws IOException {
            this(in.readString(), in.readString());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.nodeId);
            out.writeString(this.name);
        }

        void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.nodeId);
            builder.field(VerifyRepositoryResponse.NAME, this.name);
            builder.endObject();
            return builder;
        }

        DiscoveryNode convertToDiscoveryNode() {
            return new DiscoveryNode(this.name, this.nodeId, "", "", "", new TransportAddress(TransportAddress.META_ADDRESS, 0), Collections.emptyMap(), Collections.emptySet(), Version.CURRENT);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeView other = (NodeView)obj;
            return Objects.equals(this.nodeId, other.nodeId) && Objects.equals(this.name, other.name);
        }

        public int hashCode() {
            return Objects.hash(this.nodeId, this.name);
        }

        static {
            ObjectParser internalParser = new ObjectParser(VerifyRepositoryResponse.NODES);
            internalParser.declareString(NodeView::setName, new ParseField(VerifyRepositoryResponse.NAME, new String[0]));
            PARSER = (p, v, name) -> internalParser.parse(p, new NodeView(name), null);
        }
    }
}

