/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.indices.upgrade.post;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.PrimaryMissingActionException;
import conductor.org.elasticsearch.action.admin.indices.upgrade.post.ShardUpgradeResult;
import conductor.org.elasticsearch.action.admin.indices.upgrade.post.TransportUpgradeSettingsAction;
import conductor.org.elasticsearch.action.admin.indices.upgrade.post.UpgradeRequest;
import conductor.org.elasticsearch.action.admin.indices.upgrade.post.UpgradeResponse;
import conductor.org.elasticsearch.action.admin.indices.upgrade.post.UpgradeSettingsRequest;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.DefaultShardOperationFailedException;
import conductor.org.elasticsearch.action.support.broadcast.node.TransportBroadcastByNodeAction;
import conductor.org.elasticsearch.action.support.master.AcknowledgedResponse;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.block.ClusterBlockException;
import conductor.org.elasticsearch.cluster.block.ClusterBlockLevel;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.metadata.MetaData;
import conductor.org.elasticsearch.cluster.routing.IndexRoutingTable;
import conductor.org.elasticsearch.cluster.routing.RoutingTable;
import conductor.org.elasticsearch.cluster.routing.ShardRouting;
import conductor.org.elasticsearch.cluster.routing.ShardsIterator;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.collect.Tuple;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.index.shard.IndexShard;
import conductor.org.elasticsearch.indices.IndicesService;
import conductor.org.elasticsearch.tasks.Task;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TransportUpgradeAction
extends TransportBroadcastByNodeAction<UpgradeRequest, UpgradeResponse, ShardUpgradeResult> {
    private final IndicesService indicesService;
    private final TransportUpgradeSettingsAction upgradeSettingsAction;

    @Inject
    public TransportUpgradeAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, TransportUpgradeSettingsAction upgradeSettingsAction) {
        super(settings, "indices:admin/upgrade", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, UpgradeRequest::new, "force_merge");
        this.indicesService = indicesService;
        this.upgradeSettingsAction = upgradeSettingsAction;
    }

    @Override
    protected UpgradeResponse newResponse(UpgradeRequest request, int totalShards, int successfulShards, int failedShards, List<ShardUpgradeResult> shardUpgradeResults, List<DefaultShardOperationFailedException> shardFailures, ClusterState clusterState) {
        HashMap<String, Integer> successfulPrimaryShards = new HashMap<String, Integer>();
        HashMap<String, Tuple<Version, conductor.org.apache.lucene.util.Version>> versions = new HashMap<String, Tuple<Version, conductor.org.apache.lucene.util.Version>>();
        for (ShardUpgradeResult result : shardUpgradeResults) {
            Tuple versionTuple;
            ++successfulShards;
            String index = result.getShardId().getIndex().getName();
            if (result.primary()) {
                Integer count = (Integer)successfulPrimaryShards.get(index);
                successfulPrimaryShards.put(index, count == null ? 1 : count + 1);
            }
            if ((versionTuple = (Tuple)versions.get(index)) == null) {
                versions.put(index, new Tuple<Version, conductor.org.apache.lucene.util.Version>(result.upgradeVersion(), result.oldestLuceneSegment()));
                continue;
            }
            Version version = (Version)versionTuple.v1();
            conductor.org.apache.lucene.util.Version luceneVersion = (conductor.org.apache.lucene.util.Version)versionTuple.v2();
            if (result.upgradeVersion().after((Version)versionTuple.v1())) {
                version = result.upgradeVersion();
            }
            if (!result.oldestLuceneSegment().onOrAfter((conductor.org.apache.lucene.util.Version)versionTuple.v2())) {
                luceneVersion = result.oldestLuceneSegment();
            }
            versions.put(index, new Tuple<Version, conductor.org.apache.lucene.util.Version>(version, luceneVersion));
        }
        HashMap<String, Tuple<Version, String>> updatedVersions = new HashMap<String, Tuple<Version, String>>();
        MetaData metaData = clusterState.metaData();
        for (Map.Entry versionEntry : versions.entrySet()) {
            String index = (String)versionEntry.getKey();
            Integer primaryCount = (Integer)successfulPrimaryShards.get(index);
            int expectedPrimaryCount = metaData.index(index).getNumberOfShards();
            if (primaryCount.intValue() == metaData.index(index).getNumberOfShards()) {
                updatedVersions.put(index, new Tuple<Version, String>((Version)((Tuple)versionEntry.getValue()).v1(), ((conductor.org.apache.lucene.util.Version)((Tuple)versionEntry.getValue()).v2()).toString()));
                continue;
            }
            this.logger.warn("Not updating settings for the index [{}] because upgraded of some primary shards failed - expected[{}], received[{}]", (Object)index, (Object)expectedPrimaryCount, (Object)(primaryCount == null ? 0 : primaryCount));
        }
        return new UpgradeResponse(updatedVersions, totalShards, successfulShards, failedShards, shardFailures);
    }

    @Override
    protected ShardUpgradeResult shardOperation(UpgradeRequest request, ShardRouting shardRouting) throws IOException {
        IndexShard indexShard = this.indicesService.indexServiceSafe(shardRouting.shardId().getIndex()).getShard(shardRouting.shardId().id());
        conductor.org.apache.lucene.util.Version oldestLuceneSegment = indexShard.upgrade(request);
        return new ShardUpgradeResult(shardRouting.shardId(), indexShard.routingEntry().primary(), Version.CURRENT, oldestLuceneSegment);
    }

    @Override
    protected ShardUpgradeResult readShardResult(StreamInput in) throws IOException {
        ShardUpgradeResult result = new ShardUpgradeResult();
        result.readFrom(in);
        return result;
    }

    @Override
    protected UpgradeRequest readRequestFrom(StreamInput in) throws IOException {
        UpgradeRequest request = new UpgradeRequest();
        request.readFrom(in);
        return request;
    }

    @Override
    protected ShardsIterator shards(ClusterState clusterState, UpgradeRequest request, String[] concreteIndices) {
        ShardsIterator iterator = clusterState.routingTable().allShards(concreteIndices);
        Set<String> indicesWithMissingPrimaries = this.indicesWithMissingPrimaries(clusterState, concreteIndices);
        if (indicesWithMissingPrimaries.isEmpty()) {
            return iterator;
        }
        throw new PrimaryMissingActionException("Cannot upgrade indices because the following indices are missing primary shards " + indicesWithMissingPrimaries);
    }

    private Set<String> indicesWithMissingPrimaries(ClusterState clusterState, String[] concreteIndices) {
        HashSet<String> indices = new HashSet<String>();
        RoutingTable routingTable = clusterState.routingTable();
        for (String index : concreteIndices) {
            IndexRoutingTable indexRoutingTable = routingTable.index(index);
            if (indexRoutingTable.allPrimaryShardsActive()) continue;
            indices.add(index);
        }
        return indices;
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, UpgradeRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, UpgradeRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, concreteIndices);
    }

    @Override
    protected void doExecute(Task task, UpgradeRequest request, final ActionListener<UpgradeResponse> listener) {
        ActionListener<UpgradeResponse> settingsUpdateListener = new ActionListener<UpgradeResponse>(){

            @Override
            public void onResponse(UpgradeResponse upgradeResponse) {
                try {
                    if (upgradeResponse.versions().isEmpty()) {
                        listener.onResponse(upgradeResponse);
                    } else {
                        TransportUpgradeAction.this.updateSettings(upgradeResponse, listener);
                    }
                }
                catch (Exception e) {
                    listener.onFailure(e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        };
        super.doExecute(task, request, settingsUpdateListener);
    }

    private void updateSettings(final UpgradeResponse upgradeResponse, final ActionListener<UpgradeResponse> listener) {
        UpgradeSettingsRequest upgradeSettingsRequest = new UpgradeSettingsRequest(upgradeResponse.versions());
        this.upgradeSettingsAction.execute(upgradeSettingsRequest, new ActionListener<AcknowledgedResponse>(){

            @Override
            public void onResponse(AcknowledgedResponse updateSettingsResponse) {
                listener.onResponse(upgradeResponse);
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }
}

