/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.search;

import conductor.com.carrotsearch.hppc.IntArrayList;
import conductor.org.apache.logging.log4j.Logger;
import conductor.org.apache.lucene.search.ScoreDoc;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.search.ParsedScrollId;
import conductor.org.elasticsearch.action.search.SearchActionListener;
import conductor.org.elasticsearch.action.search.SearchPhase;
import conductor.org.elasticsearch.action.search.SearchPhaseController;
import conductor.org.elasticsearch.action.search.SearchResponse;
import conductor.org.elasticsearch.action.search.SearchScrollAsyncAction;
import conductor.org.elasticsearch.action.search.SearchScrollRequest;
import conductor.org.elasticsearch.action.search.SearchTask;
import conductor.org.elasticsearch.action.search.SearchTransportService;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.util.concurrent.AtomicArray;
import conductor.org.elasticsearch.common.util.concurrent.CountDown;
import conductor.org.elasticsearch.search.SearchShardTarget;
import conductor.org.elasticsearch.search.fetch.FetchSearchResult;
import conductor.org.elasticsearch.search.fetch.ShardFetchRequest;
import conductor.org.elasticsearch.search.internal.InternalScrollSearchRequest;
import conductor.org.elasticsearch.search.query.QuerySearchResult;
import conductor.org.elasticsearch.search.query.ScrollQuerySearchResult;
import conductor.org.elasticsearch.transport.Transport;
import java.io.IOException;
import java.util.function.BiFunction;

final class SearchScrollQueryThenFetchAsyncAction
extends SearchScrollAsyncAction<ScrollQuerySearchResult> {
    private final SearchTask task;
    private final AtomicArray<FetchSearchResult> fetchResults;
    private final AtomicArray<QuerySearchResult> queryResults;

    SearchScrollQueryThenFetchAsyncAction(Logger logger, ClusterService clusterService, SearchTransportService searchTransportService, SearchPhaseController searchPhaseController, SearchScrollRequest request, SearchTask task, ParsedScrollId scrollId, ActionListener<SearchResponse> listener) {
        super(scrollId, logger, clusterService.state().nodes(), listener, searchPhaseController, request, searchTransportService);
        this.task = task;
        this.fetchResults = new AtomicArray(scrollId.getContext().length);
        this.queryResults = new AtomicArray(scrollId.getContext().length);
    }

    @Override
    protected void onFirstPhaseResult(int shardId, ScrollQuerySearchResult result) {
        this.queryResults.setOnce(shardId, result.queryResult());
    }

    @Override
    protected void executeInitialPhase(Transport.Connection connection, InternalScrollSearchRequest internalRequest, SearchActionListener<ScrollQuerySearchResult> searchActionListener) {
        this.searchTransportService.sendExecuteScrollQuery(connection, internalRequest, this.task, searchActionListener);
    }

    @Override
    protected SearchPhase moveToNextPhase(final BiFunction<String, String, DiscoveryNode> clusterNodeLookup) {
        return new SearchPhase("fetch"){

            @Override
            public void run() throws IOException {
                final SearchPhaseController.ReducedQueryPhase reducedQueryPhase = SearchScrollQueryThenFetchAsyncAction.this.searchPhaseController.reducedQueryPhase(SearchScrollQueryThenFetchAsyncAction.this.queryResults.asList(), true);
                if (reducedQueryPhase.scoreDocs.length == 0) {
                    SearchScrollQueryThenFetchAsyncAction.this.sendResponse(reducedQueryPhase, SearchScrollQueryThenFetchAsyncAction.this.fetchResults);
                    return;
                }
                IntArrayList[] docIdsToLoad = SearchScrollQueryThenFetchAsyncAction.this.searchPhaseController.fillDocIdsToLoad(SearchScrollQueryThenFetchAsyncAction.this.queryResults.length(), reducedQueryPhase.scoreDocs);
                ScoreDoc[] lastEmittedDocPerShard = SearchScrollQueryThenFetchAsyncAction.this.searchPhaseController.getLastEmittedDocPerShard(reducedQueryPhase, SearchScrollQueryThenFetchAsyncAction.this.queryResults.length());
                final CountDown counter = new CountDown(docIdsToLoad.length);
                for (int i = 0; i < docIdsToLoad.length; ++i) {
                    int index = i;
                    IntArrayList docIds = docIdsToLoad[index];
                    if (docIds != null) {
                        final QuerySearchResult querySearchResult = (QuerySearchResult)SearchScrollQueryThenFetchAsyncAction.this.queryResults.get(index);
                        ScoreDoc lastEmittedDoc = lastEmittedDocPerShard[index];
                        ShardFetchRequest shardFetchRequest = new ShardFetchRequest(querySearchResult.getRequestId(), docIds, lastEmittedDoc);
                        SearchShardTarget searchShardTarget = querySearchResult.getSearchShardTarget();
                        DiscoveryNode node = (DiscoveryNode)clusterNodeLookup.apply(searchShardTarget.getClusterAlias(), searchShardTarget.getNodeId());
                        assert (node != null) : "target node is null in secondary phase";
                        Transport.Connection connection = SearchScrollQueryThenFetchAsyncAction.this.getConnection(searchShardTarget.getClusterAlias(), node);
                        SearchScrollQueryThenFetchAsyncAction.this.searchTransportService.sendExecuteFetchScroll(connection, shardFetchRequest, SearchScrollQueryThenFetchAsyncAction.this.task, new SearchActionListener<FetchSearchResult>(querySearchResult.getSearchShardTarget(), index){

                            @Override
                            protected void innerOnResponse(FetchSearchResult response) {
                                SearchScrollQueryThenFetchAsyncAction.this.fetchResults.setOnce(response.getShardIndex(), response);
                                if (counter.countDown()) {
                                    SearchScrollQueryThenFetchAsyncAction.this.sendResponse(reducedQueryPhase, SearchScrollQueryThenFetchAsyncAction.this.fetchResults);
                                }
                            }

                            @Override
                            public void onFailure(Exception t) {
                                SearchScrollQueryThenFetchAsyncAction.this.onShardFailure(this.getName(), counter, querySearchResult.getRequestId(), t, querySearchResult.getSearchShardTarget(), () -> SearchScrollQueryThenFetchAsyncAction.this.sendResponsePhase(reducedQueryPhase, SearchScrollQueryThenFetchAsyncAction.this.fetchResults));
                            }
                        });
                        continue;
                    }
                    if (!counter.countDown()) continue;
                    SearchScrollQueryThenFetchAsyncAction.this.sendResponse(reducedQueryPhase, SearchScrollQueryThenFetchAsyncAction.this.fetchResults);
                }
            }
        };
    }
}

