/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client.watcher;

import conductor.org.elasticsearch.ElasticsearchParseException;
import conductor.org.elasticsearch.client.watcher.ActionStatus;
import conductor.org.elasticsearch.client.watcher.ExecutionState;
import conductor.org.elasticsearch.client.watcher.WatchStatusDateParser;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.common.xcontent.XContentParserUtils;
import conductor.org.joda.time.DateTime;
import conductor.org.joda.time.DateTimeZone;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class WatchStatus {
    private final State state;
    private final ExecutionState executionState;
    private final DateTime lastChecked;
    private final DateTime lastMetCondition;
    private final long version;
    private final Map<String, ActionStatus> actions;

    public WatchStatus(long version, State state, ExecutionState executionState, DateTime lastChecked, DateTime lastMetCondition, Map<String, ActionStatus> actions) {
        this.version = version;
        this.lastChecked = lastChecked;
        this.lastMetCondition = lastMetCondition;
        this.actions = actions;
        this.state = state;
        this.executionState = executionState;
    }

    public State state() {
        return this.state;
    }

    public boolean checked() {
        return this.lastChecked != null;
    }

    public DateTime lastChecked() {
        return this.lastChecked;
    }

    public DateTime lastMetCondition() {
        return this.lastMetCondition;
    }

    public ActionStatus actionStatus(String actionId) {
        return this.actions.get(actionId);
    }

    public long version() {
        return this.version;
    }

    public ExecutionState getExecutionState() {
        return this.executionState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatchStatus that = (WatchStatus)o;
        return Objects.equals(this.lastChecked, that.lastChecked) && Objects.equals(this.lastMetCondition, that.lastMetCondition) && Objects.equals(this.version, that.version) && Objects.equals((Object)this.executionState, (Object)that.executionState) && Objects.equals(this.actions, that.actions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.lastChecked, this.lastMetCondition, this.actions, this.version, this.executionState});
    }

    public static WatchStatus parse(XContentParser parser) throws IOException {
        XContentParser.Token token;
        State state = null;
        ExecutionState executionState = null;
        DateTime lastChecked = null;
        DateTime lastMetCondition = null;
        Map<String, ActionStatus> actions = null;
        long version = -1L;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser::getTokenLocation);
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (Field.STATE.match(currentFieldName, parser.getDeprecationHandler())) {
                try {
                    state = State.parse(parser);
                    continue;
                }
                catch (ElasticsearchParseException e) {
                    throw new ElasticsearchParseException("could not parse watch status. failed to parse field [{}]", (Throwable)e, currentFieldName);
                }
            }
            if (Field.VERSION.match(currentFieldName, parser.getDeprecationHandler())) {
                if (token.isValue()) {
                    version = parser.longValue();
                    continue;
                }
                throw new ElasticsearchParseException("could not parse watch status. expecting field [{}] to hold a long value, found [{}] instead", new Object[]{currentFieldName, token});
            }
            if (Field.LAST_CHECKED.match(currentFieldName, parser.getDeprecationHandler())) {
                if (token.isValue()) {
                    lastChecked = WatchStatusDateParser.parseDate(currentFieldName, parser);
                    continue;
                }
                throw new ElasticsearchParseException("could not parse watch status. expecting field [{}] to hold a date value, found [{}] instead", new Object[]{currentFieldName, token});
            }
            if (Field.LAST_MET_CONDITION.match(currentFieldName, parser.getDeprecationHandler())) {
                if (token.isValue()) {
                    lastMetCondition = WatchStatusDateParser.parseDate(currentFieldName, parser);
                    continue;
                }
                throw new ElasticsearchParseException("could not parse watch status. expecting field [{}] to hold a date value, found [{}] instead", new Object[]{currentFieldName, token});
            }
            if (Field.EXECUTION_STATE.match(currentFieldName, parser.getDeprecationHandler())) {
                if (token.isValue()) {
                    executionState = ExecutionState.resolve(parser.text());
                    continue;
                }
                throw new ElasticsearchParseException("could not parse watch status. expecting field [{}] to hold a string value, found [{}] instead", new Object[]{currentFieldName, token});
            }
            if (Field.ACTIONS.match(currentFieldName, parser.getDeprecationHandler())) {
                actions = new HashMap<String, ActionStatus>();
                if (token == XContentParser.Token.START_OBJECT) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        ActionStatus actionStatus = ActionStatus.parse(currentFieldName, parser);
                        actions.put(currentFieldName, actionStatus);
                    }
                    continue;
                }
                throw new ElasticsearchParseException("could not parse watch status. expecting field [{}] to be an object, found [{}] instead", new Object[]{currentFieldName, token});
            }
            parser.skipChildren();
        }
        actions = actions == null ? Collections.emptyMap() : Collections.unmodifiableMap(actions);
        return new WatchStatus(version, state, executionState, lastChecked, lastMetCondition, actions);
    }

    public static interface Field {
        public static final ParseField STATE = new ParseField("state", new String[0]);
        public static final ParseField ACTIVE = new ParseField("active", new String[0]);
        public static final ParseField TIMESTAMP = new ParseField("timestamp", new String[0]);
        public static final ParseField LAST_CHECKED = new ParseField("last_checked", new String[0]);
        public static final ParseField LAST_MET_CONDITION = new ParseField("last_met_condition", new String[0]);
        public static final ParseField ACTIONS = new ParseField("actions", new String[0]);
        public static final ParseField VERSION = new ParseField("version", new String[0]);
        public static final ParseField EXECUTION_STATE = new ParseField("execution_state", new String[0]);
    }

    public static class State {
        private final boolean active;
        private final DateTime timestamp;

        public State(boolean active, DateTime timestamp) {
            this.active = active;
            this.timestamp = timestamp;
        }

        public boolean isActive() {
            return this.active;
        }

        public DateTime getTimestamp() {
            return this.timestamp;
        }

        public static State parse(XContentParser parser) throws IOException {
            XContentParser.Token token;
            if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
                throw new ElasticsearchParseException("expected an object but found [{}] instead", new Object[]{parser.currentToken()});
            }
            boolean active = true;
            DateTime timestamp = DateTime.now(DateTimeZone.UTC);
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (Field.ACTIVE.match(currentFieldName, parser.getDeprecationHandler())) {
                    active = parser.booleanValue();
                    continue;
                }
                if (!Field.TIMESTAMP.match(currentFieldName, parser.getDeprecationHandler())) continue;
                timestamp = WatchStatusDateParser.parseDate(currentFieldName, parser);
            }
            return new State(active, timestamp);
        }
    }
}

