/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.mapper;

import conductor.org.apache.lucene.document.InetAddressPoint;
import conductor.org.apache.lucene.document.SortedSetDocValuesField;
import conductor.org.apache.lucene.document.StoredField;
import conductor.org.apache.lucene.index.IndexOptions;
import conductor.org.apache.lucene.index.IndexableField;
import conductor.org.apache.lucene.index.SortedSetDocValues;
import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.search.DocValuesFieldExistsQuery;
import conductor.org.apache.lucene.search.MatchNoDocsQuery;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.TermQuery;
import conductor.org.apache.lucene.util.ArrayUtil;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.elasticsearch.common.Explicit;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.collect.Tuple;
import conductor.org.elasticsearch.common.network.InetAddresses;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.index.fielddata.IndexFieldData;
import conductor.org.elasticsearch.index.fielddata.ScriptDocValues;
import conductor.org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import conductor.org.elasticsearch.index.mapper.FieldMapper;
import conductor.org.elasticsearch.index.mapper.MappedFieldType;
import conductor.org.elasticsearch.index.mapper.Mapper;
import conductor.org.elasticsearch.index.mapper.MapperParsingException;
import conductor.org.elasticsearch.index.mapper.ParseContext;
import conductor.org.elasticsearch.index.mapper.SimpleMappedFieldType;
import conductor.org.elasticsearch.index.mapper.TypeParsers;
import conductor.org.elasticsearch.index.query.QueryShardContext;
import conductor.org.elasticsearch.search.DocValueFormat;
import conductor.org.joda.time.DateTimeZone;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class IpFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "ip";
    private Boolean includeInAll;
    private Explicit<Boolean> ignoreMalformed;

    private IpFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Explicit<Boolean> ignoreMalformed, Boolean includeInAll, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        this.ignoreMalformed = ignoreMalformed;
        this.includeInAll = includeInAll;
    }

    @Override
    public IpFieldType fieldType() {
        return (IpFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return this.fieldType.typeName();
    }

    @Override
    protected IpFieldMapper clone() {
        return (IpFieldMapper)super.clone();
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        InetAddress address;
        Object addressAsObject = context.externalValueSet() ? context.externalValue() : context.parser().textOrNull();
        if (addressAsObject == null) {
            addressAsObject = this.fieldType().nullValue();
        }
        if (addressAsObject == null) {
            return;
        }
        String addressAsString = addressAsObject.toString();
        if (addressAsObject instanceof InetAddress) {
            address = (InetAddress)addressAsObject;
        } else {
            try {
                address = InetAddresses.forString(addressAsString);
            }
            catch (IllegalArgumentException e) {
                if (this.ignoreMalformed.value().booleanValue()) {
                    context.addIgnoredField(this.fieldType.name());
                    return;
                }
                throw e;
            }
        }
        if (context.includeInAll(this.includeInAll, this)) {
            context.allEntries().addText(this.fieldType().name(), addressAsString, this.fieldType().boost());
        }
        if (this.fieldType().indexOptions() != IndexOptions.NONE) {
            fields.add(new InetAddressPoint(this.fieldType().name(), address));
        }
        if (this.fieldType().hasDocValues()) {
            fields.add(new SortedSetDocValuesField(this.fieldType().name(), new BytesRef(InetAddressPoint.encode(address))));
        } else if (this.fieldType().stored() || this.fieldType().indexOptions() != IndexOptions.NONE) {
            this.createFieldNamesField(context, fields);
        }
        if (this.fieldType().stored()) {
            fields.add(new StoredField(this.fieldType().name(), new BytesRef(InetAddressPoint.encode(address))));
        }
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        super.doMerge(mergeWith, updateAllTypes);
        IpFieldMapper other = (IpFieldMapper)mergeWith;
        this.includeInAll = other.includeInAll;
        if (other.ignoreMalformed.explicit()) {
            this.ignoreMalformed = other.ignoreMalformed;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.fieldType().nullValue() != null) {
            Object nullValue = this.fieldType().nullValue();
            if (nullValue != null) {
                nullValue = InetAddresses.toAddrString((InetAddress)nullValue);
            }
            builder.field("null_value", nullValue);
        }
        if (includeDefaults || this.ignoreMalformed.explicit()) {
            builder.field("ignore_malformed", this.ignoreMalformed.value());
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", this.includeInAll);
        } else if (includeDefaults) {
            builder.field("include_in_all", false);
        }
    }

    public static final class IpFieldType
    extends SimpleMappedFieldType {
        public IpFieldType() {
            this.setTokenized(false);
            this.setHasDocValues(true);
        }

        IpFieldType(IpFieldType other) {
            super(other);
        }

        @Override
        public MappedFieldType clone() {
            return new IpFieldType(this);
        }

        @Override
        public String typeName() {
            return IpFieldMapper.CONTENT_TYPE;
        }

        private InetAddress parse(Object value) {
            if (value instanceof InetAddress) {
                return (InetAddress)value;
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return InetAddresses.forString(value.toString());
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            if (this.hasDocValues()) {
                return new DocValuesFieldExistsQuery(this.name());
            }
            return new TermQuery(new Term("_field_names", this.name()));
        }

        @Override
        public Query termQuery(Object value, @Nullable QueryShardContext context) {
            String term;
            this.failIfNotIndexed();
            if (value instanceof InetAddress) {
                return InetAddressPoint.newExactQuery(this.name(), (InetAddress)value);
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            if ((term = value.toString()).contains("/")) {
                Tuple<InetAddress, Integer> cidr = InetAddresses.parseCidr(term);
                return InetAddressPoint.newPrefixQuery(this.name(), cidr.v1(), cidr.v2());
            }
            InetAddress address = InetAddresses.forString(term);
            return InetAddressPoint.newExactQuery(this.name(), address);
        }

        @Override
        public Query termsQuery(List<?> values, QueryShardContext context) {
            InetAddress[] addresses = new InetAddress[values.size()];
            int i = 0;
            for (Object value : values) {
                InetAddress address;
                if (value instanceof InetAddress) {
                    address = (InetAddress)value;
                } else {
                    if (value instanceof BytesRef) {
                        value = ((BytesRef)value).utf8ToString();
                    }
                    if (value.toString().contains("/")) {
                        return super.termsQuery(values, context);
                    }
                    address = InetAddresses.forString(value.toString());
                }
                addresses[i++] = address;
            }
            return InetAddressPoint.newSetQuery(this.name(), addresses);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            InetAddress upper;
            InetAddress lower;
            this.failIfNotIndexed();
            if (lowerTerm == null) {
                lower = InetAddressPoint.MIN_VALUE;
            } else {
                lower = this.parse(lowerTerm);
                if (!includeLower) {
                    if (lower.equals(InetAddressPoint.MAX_VALUE)) {
                        return new MatchNoDocsQuery();
                    }
                    lower = InetAddressPoint.nextUp(lower);
                }
            }
            if (upperTerm == null) {
                upper = InetAddressPoint.MAX_VALUE;
            } else {
                upper = this.parse(upperTerm);
                if (!includeUpper) {
                    if (upper.equals(InetAddressPoint.MIN_VALUE)) {
                        return new MatchNoDocsQuery();
                    }
                    upper = InetAddressPoint.nextDown(upper);
                }
            }
            return InetAddressPoint.newRangeQuery(this.name(), lower, upper);
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            this.failIfNoDocValues();
            return new DocValuesIndexFieldData.Builder().scriptFunction(IpScriptDocValues::new);
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            return DocValueFormat.IP.format((BytesRef)value);
        }

        @Override
        public DocValueFormat docValueFormat(@Nullable String format, DateTimeZone timeZone) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom formats");
            }
            if (timeZone != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
            }
            return DocValueFormat.IP;
        }

        public static final class IpScriptDocValues
        extends ScriptDocValues<String> {
            private final SortedSetDocValues in;
            private long[] ords = new long[0];
            private int count;

            public IpScriptDocValues(SortedSetDocValues in) {
                this.in = in;
            }

            @Override
            public void setNextDocId(int docId) throws IOException {
                this.count = 0;
                if (this.in.advanceExact(docId)) {
                    long ord = this.in.nextOrd();
                    while (ord != -1L) {
                        this.ords = ArrayUtil.grow(this.ords, this.count + 1);
                        this.ords[this.count++] = ord;
                        ord = this.in.nextOrd();
                    }
                }
            }

            public String getValue() {
                if (this.count == 0) {
                    return null;
                }
                return this.get(0);
            }

            @Override
            public String get(int index) {
                try {
                    BytesRef encoded = this.in.lookupOrd(this.ords[index]);
                    InetAddress address = InetAddressPoint.decode(Arrays.copyOfRange(encoded.bytes, encoded.offset, encoded.offset + encoded.length));
                    return InetAddresses.toAddrString(address);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public int size() {
                return this.count;
            }
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            TypeParsers.parseField(builder, name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (propName.equals("null_value")) {
                    if (propNode == null) {
                        throw new MapperParsingException("Property [null_value] cannot be null.");
                    }
                    builder.nullValue(InetAddresses.forString(propNode.toString()));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("ignore_malformed")) {
                    builder.ignoreMalformed(TypeParsers.nodeBooleanValue(name, "ignore_malformed", propNode, parserContext));
                    iterator.remove();
                    continue;
                }
                if (!TypeParsers.parseMultiField(builder, name, parserContext, propName, propNode)) continue;
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, IpFieldMapper> {
        private Boolean ignoreMalformed;

        public Builder(String name) {
            super(name, new IpFieldType(), new IpFieldType());
            this.builder = this;
        }

        public Builder ignoreMalformed(boolean ignoreMalformed) {
            this.ignoreMalformed = ignoreMalformed;
            return (Builder)this.builder;
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit<Boolean>(this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(FieldMapper.IGNORE_MALFORMED_SETTING.get(context.indexSettings()), false);
            }
            return Defaults.IGNORE_MALFORMED;
        }

        @Override
        public IpFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new IpFieldMapper(this.name, this.fieldType, this.defaultFieldType, this.ignoreMalformed(context), this.includeInAll, context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }

    public static class Defaults {
        public static final Explicit<Boolean> IGNORE_MALFORMED = new Explicit<Boolean>(false, false);
    }
}

