/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.shard;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Streamable;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentFragment;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import java.io.IOException;

public class DocsStats
implements Streamable,
ToXContentFragment {
    long count = 0L;
    long deleted = 0L;
    long totalSizeInBytes = 0L;

    public DocsStats() {
    }

    public DocsStats(long count, long deleted, long totalSizeInBytes) {
        this.count = count;
        this.deleted = deleted;
        this.totalSizeInBytes = totalSizeInBytes;
    }

    public void add(DocsStats other) {
        if (other == null) {
            return;
        }
        if (this.totalSizeInBytes == -1L) {
            this.totalSizeInBytes = other.totalSizeInBytes;
        } else if (other.totalSizeInBytes != -1L) {
            this.totalSizeInBytes += other.totalSizeInBytes;
        }
        this.count += other.count;
        this.deleted += other.deleted;
    }

    public long getCount() {
        return this.count;
    }

    public long getDeleted() {
        return this.deleted;
    }

    public long getTotalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    public long getAverageSizeInBytes() {
        long totalDocs = this.count + this.deleted;
        return totalDocs == 0L ? 0L : this.totalSizeInBytes / totalDocs;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.count = in.readVLong();
        this.deleted = in.readVLong();
        this.totalSizeInBytes = in.getVersion().onOrAfter(Version.V_6_1_0) ? in.readVLong() : -1L;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.count);
        out.writeVLong(this.deleted);
        if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
            out.writeVLong(this.totalSizeInBytes);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("docs");
        builder.field("count", this.count);
        builder.field("deleted", this.deleted);
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String DOCS = "docs";
        static final String COUNT = "count";
        static final String DELETED = "deleted";

        Fields() {
        }
    }
}

