/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search;

import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Writeable;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentFragment;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.common.xcontent.XContentParserUtils;
import conductor.org.elasticsearch.search.DocValueFormat;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public class SearchSortValues
implements ToXContentFragment,
Writeable {
    static final SearchSortValues EMPTY = new SearchSortValues(new Object[0]);
    private final Object[] sortValues;

    SearchSortValues(Object[] sortValues) {
        this.sortValues = Objects.requireNonNull(sortValues, "sort values must not be empty");
    }

    public SearchSortValues(Object[] sortValues, DocValueFormat[] sortValueFormats) {
        Objects.requireNonNull(sortValues);
        Objects.requireNonNull(sortValueFormats);
        this.sortValues = Arrays.copyOf(sortValues, sortValues.length);
        for (int i = 0; i < sortValues.length; ++i) {
            if (!(this.sortValues[i] instanceof BytesRef)) continue;
            this.sortValues[i] = sortValueFormats[i].format((BytesRef)sortValues[i]);
        }
    }

    public SearchSortValues(StreamInput in) throws IOException {
        int size = in.readVInt();
        if (size > 0) {
            this.sortValues = new Object[size];
            for (int i = 0; i < this.sortValues.length; ++i) {
                byte type = in.readByte();
                if (type == 0) {
                    this.sortValues[i] = null;
                    continue;
                }
                if (type == 1) {
                    this.sortValues[i] = in.readString();
                    continue;
                }
                if (type == 2) {
                    this.sortValues[i] = in.readInt();
                    continue;
                }
                if (type == 3) {
                    this.sortValues[i] = in.readLong();
                    continue;
                }
                if (type == 4) {
                    this.sortValues[i] = Float.valueOf(in.readFloat());
                    continue;
                }
                if (type == 5) {
                    this.sortValues[i] = in.readDouble();
                    continue;
                }
                if (type == 6) {
                    this.sortValues[i] = in.readByte();
                    continue;
                }
                if (type == 7) {
                    this.sortValues[i] = in.readShort();
                    continue;
                }
                if (type == 8) {
                    this.sortValues[i] = in.readBoolean();
                    continue;
                }
                throw new IOException("Can't match type [" + type + "]");
            }
        } else {
            this.sortValues = new Object[0];
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.sortValues.length);
        for (Object sortValue : this.sortValues) {
            if (sortValue == null) {
                out.writeByte((byte)0);
                continue;
            }
            Class<?> type = sortValue.getClass();
            if (type == String.class) {
                out.writeByte((byte)1);
                out.writeString((String)sortValue);
                continue;
            }
            if (type == Integer.class) {
                out.writeByte((byte)2);
                out.writeInt((Integer)sortValue);
                continue;
            }
            if (type == Long.class) {
                out.writeByte((byte)3);
                out.writeLong((Long)sortValue);
                continue;
            }
            if (type == Float.class) {
                out.writeByte((byte)4);
                out.writeFloat(((Float)sortValue).floatValue());
                continue;
            }
            if (type == Double.class) {
                out.writeByte((byte)5);
                out.writeDouble((Double)sortValue);
                continue;
            }
            if (type == Byte.class) {
                out.writeByte((byte)6);
                out.writeByte((Byte)sortValue);
                continue;
            }
            if (type == Short.class) {
                out.writeByte((byte)7);
                out.writeShort((Short)sortValue);
                continue;
            }
            if (type == Boolean.class) {
                out.writeByte((byte)8);
                out.writeBoolean((Boolean)sortValue);
                continue;
            }
            throw new IOException("Can't handle sort field value of type [" + type + "]");
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.sortValues.length > 0) {
            builder.startArray("sort");
            for (Object sortValue : this.sortValues) {
                builder.value(sortValue);
            }
            builder.endArray();
        }
        return builder;
    }

    public static SearchSortValues fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, parser.currentToken(), parser::getTokenLocation);
        return new SearchSortValues(parser.list().toArray());
    }

    public Object[] sortValues() {
        return this.sortValues;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SearchSortValues other = (SearchSortValues)obj;
        return Arrays.equals(this.sortValues, other.sortValues);
    }

    public int hashCode() {
        return Arrays.hashCode(this.sortValues);
    }
}

