/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.bucket.filter;

import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.index.query.AbstractQueryBuilder;
import conductor.org.elasticsearch.index.query.QueryBuilder;
import conductor.org.elasticsearch.index.query.QueryRewriteContext;
import conductor.org.elasticsearch.index.query.Rewriteable;
import conductor.org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import conductor.org.elasticsearch.search.aggregations.AggregationBuilder;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactories;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactory;
import conductor.org.elasticsearch.search.aggregations.bucket.filter.FilterAggregatorFactory;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public class FilterAggregationBuilder
extends AbstractAggregationBuilder<FilterAggregationBuilder> {
    public static final String NAME = "filter";
    private final QueryBuilder filter;

    public FilterAggregationBuilder(String name, QueryBuilder filter) {
        super(name);
        if (filter == null) {
            throw new IllegalArgumentException("[filter] must not be null: [" + name + "]");
        }
        this.filter = filter;
    }

    protected FilterAggregationBuilder(FilterAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        super(clone, factoriesBuilder, metaData);
        this.filter = clone.filter;
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        return new FilterAggregationBuilder(this, factoriesBuilder, metaData);
    }

    public FilterAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.filter = in.readNamedWriteable(QueryBuilder.class);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.filter);
    }

    @Override
    protected AggregationBuilder doRewrite(QueryRewriteContext queryShardContext) throws IOException {
        QueryBuilder result = Rewriteable.rewrite(this.filter, queryShardContext);
        if (result != this.filter) {
            return new FilterAggregationBuilder(this.getName(), result);
        }
        return this;
    }

    @Override
    protected AggregatorFactory<?> doBuild(SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new FilterAggregatorFactory(this.name, this.filter, context, parent, subFactoriesBuilder, this.metaData);
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.filter != null) {
            this.filter.toXContent(builder, params);
        }
        return builder;
    }

    public static FilterAggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        QueryBuilder filter = AbstractQueryBuilder.parseInnerQueryBuilder(parser);
        return new FilterAggregationBuilder(aggregationName, filter);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.filter);
    }

    @Override
    protected boolean doEquals(Object obj) {
        FilterAggregationBuilder other = (FilterAggregationBuilder)obj;
        return Objects.equals(this.filter, other.filter);
    }

    @Override
    public String getType() {
        return NAME;
    }

    public QueryBuilder getFilter() {
        return this.filter;
    }
}

