/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.metrics.weighted_avg;

import conductor.org.elasticsearch.common.xcontent.ObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.search.aggregations.Aggregation;
import conductor.org.elasticsearch.search.aggregations.metrics.ParsedSingleValueNumericMetricsAggregation;
import conductor.org.elasticsearch.search.aggregations.metrics.weighted_avg.WeightedAvg;
import java.io.IOException;

public class ParsedWeightedAvg
extends ParsedSingleValueNumericMetricsAggregation
implements WeightedAvg {
    private static final ObjectParser<ParsedWeightedAvg, Void> PARSER = new ObjectParser(ParsedWeightedAvg.class.getSimpleName(), true, ParsedWeightedAvg::new);

    @Override
    public double getValue() {
        return this.value();
    }

    @Override
    public String getType() {
        return "weighted_avg";
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean hasValue = this.value != Double.POSITIVE_INFINITY;
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), hasValue ? Double.valueOf(this.value) : null);
        if (hasValue && this.valueAsString != null) {
            builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.valueAsString);
        }
        return builder;
    }

    public static ParsedWeightedAvg fromXContent(XContentParser parser, String name) {
        ParsedWeightedAvg avg = PARSER.apply(parser, null);
        avg.setName(name);
        return avg;
    }

    static {
        ParsedWeightedAvg.declareSingleValueFields(PARSER, Double.POSITIVE_INFINITY);
    }
}

