/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.fetch.subphase;

import conductor.org.apache.lucene.search.FieldDoc;
import conductor.org.apache.lucene.search.ScoreDoc;
import conductor.org.apache.lucene.search.TopDocs;
import conductor.org.elasticsearch.index.mapper.Uid;
import conductor.org.elasticsearch.search.SearchHit;
import conductor.org.elasticsearch.search.SearchHits;
import conductor.org.elasticsearch.search.fetch.FetchPhase;
import conductor.org.elasticsearch.search.fetch.FetchSearchResult;
import conductor.org.elasticsearch.search.fetch.FetchSubPhase;
import conductor.org.elasticsearch.search.fetch.subphase.InnerHitsContext;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class InnerHitsFetchSubPhase
implements FetchSubPhase {
    private final FetchPhase fetchPhase;

    public InnerHitsFetchSubPhase(FetchPhase fetchPhase) {
        this.fetchPhase = fetchPhase;
    }

    @Override
    public void hitsExecute(SearchContext context, SearchHit[] hits) throws IOException {
        if (!(context.innerHits() != null && context.innerHits().getInnerHits().size() > 0)) {
            return;
        }
        for (Map.Entry<String, InnerHitsContext.InnerHitSubContext> entry : context.innerHits().getInnerHits().entrySet()) {
            InnerHitsContext.InnerHitSubContext innerHits = entry.getValue();
            TopDocs[] topDocs = innerHits.topDocs(hits);
            for (int i = 0; i < hits.length; ++i) {
                SearchHit hit = hits[i];
                TopDocs topDoc = topDocs[i];
                Map<String, SearchHits> results = hit.getInnerHits();
                if (results == null) {
                    results = new HashMap<String, SearchHits>();
                    hit.setInnerHits(results);
                }
                innerHits.queryResult().topDocs(topDoc, innerHits.sort() == null ? null : innerHits.sort().formats);
                int[] docIdsToLoad = new int[topDoc.scoreDocs.length];
                for (int j = 0; j < topDoc.scoreDocs.length; ++j) {
                    docIdsToLoad[j] = topDoc.scoreDocs[j].doc;
                }
                innerHits.docIdsToLoad(docIdsToLoad, 0, docIdsToLoad.length);
                innerHits.setUid(new Uid(hit.getType(), hit.getId()));
                this.fetchPhase.execute(innerHits);
                FetchSearchResult fetchResult = innerHits.fetchResult();
                SearchHit[] internalHits = fetchResult.fetchResult().hits().getHits();
                for (int j = 0; j < internalHits.length; ++j) {
                    ScoreDoc scoreDoc = topDoc.scoreDocs[j];
                    SearchHit searchHitFields = internalHits[j];
                    searchHitFields.score(scoreDoc.score);
                    if (!(scoreDoc instanceof FieldDoc)) continue;
                    FieldDoc fieldDoc = (FieldDoc)scoreDoc;
                    searchHitFields.sortValues(fieldDoc.fields, innerHits.sort().formats);
                }
                results.put(entry.getKey(), fetchResult.hits());
            }
        }
    }
}

