/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.threadpool;

import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Writeable;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentFragment;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ThreadPoolInfo
implements Writeable,
Iterable<ThreadPool.Info>,
ToXContentFragment {
    private final List<ThreadPool.Info> infos;

    public ThreadPoolInfo(List<ThreadPool.Info> infos) {
        this.infos = Collections.unmodifiableList(infos);
    }

    public ThreadPoolInfo(StreamInput in) throws IOException {
        this.infos = Collections.unmodifiableList(in.readList(ThreadPool.Info::new));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.infos);
    }

    @Override
    public Iterator<ThreadPool.Info> iterator() {
        return this.infos.iterator();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("thread_pool");
        for (ThreadPool.Info info : this.infos) {
            info.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String THREAD_POOL = "thread_pool";

        Fields() {
        }
    }
}

