/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.dao.es6.index.query.parser;

import com.netflix.conductor.dao.es6.index.query.parser.FilterProvider;
import com.netflix.conductor.elasticsearch.query.parser.AbstractNode;
import com.netflix.conductor.elasticsearch.query.parser.ComparisonOp;
import com.netflix.conductor.elasticsearch.query.parser.ConstValue;
import com.netflix.conductor.elasticsearch.query.parser.ListConst;
import com.netflix.conductor.elasticsearch.query.parser.Name;
import com.netflix.conductor.elasticsearch.query.parser.ParserException;
import com.netflix.conductor.elasticsearch.query.parser.Range;
import conductor.org.elasticsearch.index.query.QueryBuilder;
import conductor.org.elasticsearch.index.query.QueryBuilders;
import java.io.InputStream;

public class NameValue
extends AbstractNode
implements FilterProvider {
    private Name name;
    private ComparisonOp op;
    private ConstValue value;
    private Range range;
    private ListConst valueList;

    public NameValue(InputStream is) throws ParserException {
        super(is);
    }

    @Override
    protected void _parse() throws Exception {
        this.name = new Name(this.is);
        this.op = new ComparisonOp(this.is);
        if (this.op.getOperator().equals(ComparisonOp.Operators.BETWEEN.value())) {
            this.range = new Range(this.is);
        }
        if (this.op.getOperator().equals(ComparisonOp.Operators.IN.value())) {
            this.valueList = new ListConst(this.is);
        } else {
            this.value = new ConstValue(this.is);
        }
    }

    public String toString() {
        return "" + this.name + this.op + this.value;
    }

    public Name getName() {
        return this.name;
    }

    public ComparisonOp getOp() {
        return this.op;
    }

    public ConstValue getValue() {
        return this.value;
    }

    @Override
    public QueryBuilder getFilterBuilder() {
        if (this.op.getOperator().equals(ComparisonOp.Operators.EQUALS.value())) {
            return QueryBuilders.queryStringQuery(this.name.getName() + ":" + this.value.getValue().toString());
        }
        if (this.op.getOperator().equals(ComparisonOp.Operators.BETWEEN.value())) {
            return QueryBuilders.rangeQuery(this.name.getName()).from(this.range.getLow()).to(this.range.getHigh());
        }
        if (this.op.getOperator().equals(ComparisonOp.Operators.IN.value())) {
            return QueryBuilders.termsQuery(this.name.getName(), this.valueList.getList());
        }
        if (this.op.getOperator().equals(ComparisonOp.Operators.NOT_EQUALS.value())) {
            return QueryBuilders.queryStringQuery("NOT " + this.name.getName() + ":" + this.value.getValue().toString());
        }
        if (this.op.getOperator().equals(ComparisonOp.Operators.GREATER_THAN.value())) {
            return QueryBuilders.rangeQuery(this.name.getName()).from(this.value.getValue()).includeLower(false).includeUpper(false);
        }
        if (this.op.getOperator().equals(ComparisonOp.Operators.IS.value())) {
            if (this.value.getSysConstant().equals((Object)ConstValue.SystemConsts.NULL)) {
                return QueryBuilders.boolQuery().mustNot(QueryBuilders.boolQuery().must(QueryBuilders.matchAllQuery()).mustNot(QueryBuilders.existsQuery(this.name.getName())));
            }
            if (this.value.getSysConstant().equals((Object)ConstValue.SystemConsts.NOT_NULL)) {
                return QueryBuilders.boolQuery().mustNot(QueryBuilders.boolQuery().must(QueryBuilders.matchAllQuery()).must(QueryBuilders.existsQuery(this.name.getName())));
            }
        } else {
            if (this.op.getOperator().equals(ComparisonOp.Operators.LESS_THAN.value())) {
                return QueryBuilders.rangeQuery(this.name.getName()).to(this.value.getValue()).includeLower(false).includeUpper(false);
            }
            if (this.op.getOperator().equals(ComparisonOp.Operators.STARTS_WITH.value())) {
                return QueryBuilders.prefixQuery(this.name.getName(), this.value.getUnquotedValue());
            }
        }
        throw new IllegalStateException("Incorrect/unsupported operators");
    }
}

