/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.elasticsearch.es6;

import com.netflix.conductor.elasticsearch.EmbeddedElasticSearch;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.node.InternalSettingsPreparer;
import conductor.org.elasticsearch.node.Node;
import conductor.org.elasticsearch.plugins.Plugin;
import conductor.org.elasticsearch.transport.Netty4Plugin;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedElasticSearchV6
implements EmbeddedElasticSearch {
    private static final Logger logger = LoggerFactory.getLogger(EmbeddedElasticSearchV6.class);
    private final String clusterName;
    private final String host;
    private final int port;
    private Node instance;
    private File dataDir;

    public EmbeddedElasticSearchV6(String clusterName, String host, int port) {
        this.clusterName = clusterName;
        this.host = host;
        this.port = port;
    }

    public void start() throws Exception {
        this.start(this.clusterName, this.host, this.port);
    }

    public synchronized void start(String clusterName, String host, int port) throws Exception {
        if (this.instance != null) {
            String msg = String.format("An instance of this Embedded Elastic Search server is already running on port: %s.  It must be stopped before you can call start again.", this.getPort());
            logger.error(msg);
            throw new IllegalStateException(msg);
        }
        Settings settings = this.getSettings(clusterName, host, port);
        this.dataDir = this.setupDataDir(settings.get("path.data"));
        logger.info("Starting ElasticSearch for cluster {} ", (Object)settings.get("cluster.name"));
        this.instance = new PluginConfigurableNode(settings, Collections.singletonList(Netty4Plugin.class));
        this.instance.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                if (this.instance != null) {
                    this.instance.close();
                }
            }
            catch (IOException e) {
                logger.error("Error closing ElasticSearch");
            }
        }));
        logger.info("ElasticSearch cluster {} started in local mode on port {}", (Object)this.instance.settings().get("cluster.name"), (Object)this.getPort());
    }

    private Settings getSettings(String clusterName, String host, int port) throws IOException {
        this.dataDir = Files.createTempDirectory(clusterName + "_" + System.currentTimeMillis() + "data", new FileAttribute[0]).toFile();
        File homeDir = Files.createTempDirectory(clusterName + "_" + System.currentTimeMillis() + "-home", new FileAttribute[0]).toFile();
        Settings.Builder settingsBuilder = Settings.builder().put("cluster.name", clusterName).put("http.host", host).put("http.port", port).put("transport.tcp.port", port + 100).put("path.data", this.dataDir.getAbsolutePath()).put("path.home", homeDir.getAbsolutePath()).put("http.enabled", true).put("node.data", true).put("http.enabled", true).put("http.type", "netty4").put("transport.type", "netty4");
        return settingsBuilder.build();
    }

    private String getPort() {
        return this.instance.settings().get("http.port");
    }

    public synchronized void stop() throws Exception {
        if (this.instance != null && !this.instance.isClosed()) {
            String port = this.getPort();
            logger.info("Stopping Elastic Search");
            this.instance.close();
            this.instance = null;
            logger.info("Elastic Search on port {} stopped", (Object)port);
        }
    }

    private class PluginConfigurableNode
    extends Node {
        public PluginConfigurableNode(Settings preparedSettings, Collection<Class<? extends Plugin>> classpathPlugins) {
            super(InternalSettingsPreparer.prepareEnvironment(preparedSettings, null), classpathPlugins, false);
        }

        @Override
        protected void registerDerivedNodeNameWithLogger(String nodeName) {
            logger.info("Registered derived node name {} with logger", (Object)nodeName);
        }
    }
}

