/*
 * Decompiled with CFR 0.152.
 */
package conductor.com.carrotsearch.hppc;

import conductor.com.carrotsearch.hppc.AbstractIterator;
import conductor.com.carrotsearch.hppc.AbstractObjectCollection;
import conductor.com.carrotsearch.hppc.ArraySizingStrategy;
import conductor.com.carrotsearch.hppc.BitMixer;
import conductor.com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import conductor.com.carrotsearch.hppc.ObjectContainer;
import conductor.com.carrotsearch.hppc.ObjectIndexedContainer;
import conductor.com.carrotsearch.hppc.Preallocable;
import conductor.com.carrotsearch.hppc.cursors.ObjectCursor;
import conductor.com.carrotsearch.hppc.predicates.ObjectPredicate;
import conductor.com.carrotsearch.hppc.procedures.ObjectProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ObjectArrayList<KType>
extends AbstractObjectCollection<KType>
implements ObjectIndexedContainer<KType>,
Preallocable,
Cloneable {
    public static final Object[] EMPTY_ARRAY = new Object[0];
    public Object[] buffer = EMPTY_ARRAY;
    public int elementsCount;
    protected final ArraySizingStrategy resizer;

    public ObjectArrayList() {
        this(4);
    }

    public ObjectArrayList(int expectedElements) {
        this(expectedElements, new BoundedProportionalArraySizingStrategy());
    }

    public ObjectArrayList(int expectedElements, ArraySizingStrategy resizer) {
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureCapacity(expectedElements);
    }

    public ObjectArrayList(ObjectContainer<? extends KType> container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public void add(KType e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public void add(KType e1, KType e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public void add(KType[] elements, int start, int length) {
        assert (length >= 0) : "Length must be >= 0";
        this.ensureBufferSpace(length);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, length);
        this.elementsCount += length;
    }

    @Override
    @SafeVarargs
    public final void add(KType ... elements) {
        this.add(elements, 0, elements.length);
    }

    public int addAll(ObjectContainer<? extends KType> container) {
        int size = container.size();
        this.ensureBufferSpace(size);
        for (ObjectCursor<KType> objectCursor : container) {
            this.add((KType)objectCursor.value);
        }
        return size;
    }

    public int addAll(Iterable<? extends ObjectCursor<? extends KType>> iterable) {
        int size = 0;
        for (ObjectCursor<KType> objectCursor : iterable) {
            this.add((KType)objectCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public void insert(int index, KType e1) {
        assert (index >= 0 && index <= this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "].";
        this.ensureBufferSpace(1);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.elementsCount - index);
        this.buffer[index] = e1;
        ++this.elementsCount;
    }

    @Override
    public KType get(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        return (KType)this.buffer[index];
    }

    @Override
    public KType set(int index, KType e1) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        Object v = this.buffer[index];
        this.buffer[index] = e1;
        return (KType)v;
    }

    @Override
    public KType remove(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        Object v = this.buffer[index];
        if (index + 1 < this.elementsCount) {
            System.arraycopy(this.buffer, index + 1, this.buffer, index, this.elementsCount - index - 1);
        }
        --this.elementsCount;
        this.buffer[this.elementsCount] = null;
        return (KType)v;
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        System.arraycopy(this.buffer, toIndex, this.buffer, fromIndex, this.elementsCount - toIndex);
        int count = toIndex - fromIndex;
        this.elementsCount -= count;
        Arrays.fill(this.buffer, this.elementsCount, this.elementsCount + count, null);
    }

    @Override
    public int removeFirst(KType e1) {
        int index = this.indexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public int removeLast(KType e1) {
        int index = this.lastIndexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public int removeAll(KType e1) {
        int to = 0;
        for (int from = 0; from < this.elementsCount; ++from) {
            if (this.equals(this.buffer[from], e1)) {
                this.buffer[from] = null;
                continue;
            }
            if (to != from) {
                this.buffer[to] = this.buffer[from];
                this.buffer[from] = null;
            }
            ++to;
        }
        int deleted = this.elementsCount - to;
        this.elementsCount = to;
        return deleted;
    }

    @Override
    public boolean contains(KType e1) {
        return this.indexOf(e1) >= 0;
    }

    @Override
    public int indexOf(KType e1) {
        for (int i = 0; i < this.elementsCount; ++i) {
            if (!this.equals(this.buffer[i], e1)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(KType e1) {
        for (int i = this.elementsCount - 1; i >= 0; --i) {
            if (!this.equals(this.buffer[i], e1)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.elementsCount == 0;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (expectedElements > bufferLen) {
            this.ensureBufferSpace(expectedElements - this.size());
        }
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (this.elementsCount + expectedAdditions > bufferLen) {
            int newSize = this.resizer.grow(bufferLen, this.elementsCount, expectedAdditions);
            assert (newSize >= this.elementsCount + expectedAdditions) : "Resizer failed to return sensible new size: " + newSize + " <= " + (this.elementsCount + expectedAdditions);
            this.buffer = Arrays.copyOf(this.buffer, newSize);
        }
    }

    public void resize(int newSize) {
        if (newSize <= this.buffer.length) {
            if (newSize < this.elementsCount) {
                Arrays.fill(this.buffer, newSize, this.elementsCount, null);
            } else {
                Arrays.fill(this.buffer, this.elementsCount, newSize, null);
            }
        } else {
            this.ensureCapacity(newSize);
        }
        this.elementsCount = newSize;
    }

    @Override
    public int size() {
        return this.elementsCount;
    }

    public void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.buffer, 0, this.elementsCount, null);
        this.elementsCount = 0;
    }

    @Override
    public void release() {
        this.buffer = EMPTY_ARRAY;
        this.elementsCount = 0;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.buffer, this.elementsCount);
    }

    public ObjectArrayList<KType> clone() {
        try {
            ObjectArrayList cloned = (ObjectArrayList)super.clone();
            cloned.buffer = (Object[])this.buffer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        int h = 1;
        int max = this.elementsCount;
        for (int i = 0; i < max; ++i) {
            h = 31 * h + BitMixer.mix(this.buffer[i]);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.equalElements((ObjectArrayList)this.getClass().cast(obj));
    }

    protected boolean equalElements(ObjectArrayList<?> other) {
        int max = this.size();
        if (other.size() != max) {
            return false;
        }
        for (int i = 0; i < max; ++i) {
            if (this.equals(other.get(i), this.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<ObjectCursor<KType>> iterator() {
        return new ValueIterator<Object>(this.buffer, this.size());
    }

    @Override
    public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
        return this.forEach(procedure, 0, this.size());
    }

    public <T extends ObjectProcedure<? super KType>> T forEach(T procedure, int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        Object[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex; ++i) {
            procedure.apply((Object)buffer[i]);
        }
        return procedure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        int from;
        Object[] buffer = this.buffer;
        int elementsCount = this.elementsCount;
        int to = 0;
        try {
            for (from = 0; from < elementsCount; ++from) {
                if (predicate.apply(buffer[from])) {
                    buffer[from] = null;
                    continue;
                }
                if (to != from) {
                    buffer[to] = buffer[from];
                    buffer[from] = null;
                }
                ++to;
            }
        }
        finally {
            while (from < elementsCount) {
                if (to != from) {
                    buffer[to] = buffer[from];
                    buffer[from] = null;
                }
                ++to;
                ++from;
            }
            this.elementsCount = to;
        }
        return elementsCount - to;
    }

    @Override
    public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
        return this.forEach(predicate, 0, this.size());
    }

    public <T extends ObjectPredicate<? super KType>> T forEach(T predicate, int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        Object[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex && predicate.apply((Object)buffer[i]); ++i) {
        }
        return predicate;
    }

    @SafeVarargs
    public static <KType> ObjectArrayList<KType> from(KType ... elements) {
        ObjectArrayList<KType> list = new ObjectArrayList<KType>(elements.length);
        list.add(elements);
        return list;
    }

    static final class ValueIterator<KType>
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor = new ObjectCursor();
        private final KType[] buffer;
        private final int size;

        public ValueIterator(KType[] buffer, int size) {
            this.cursor.index = -1;
            this.size = size;
            this.buffer = buffer;
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            if (this.cursor.index + 1 == this.size) {
                return (ObjectCursor)this.done();
            }
            this.cursor.value = this.buffer[++this.cursor.index];
            return this.cursor;
        }
    }
}

