/*
 * Decompiled with CFR 0.152.
 */
package conductor.com.github.mustachejava.resolver;

import conductor.com.github.mustachejava.MustacheResolver;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public class ClasspathResolver
implements MustacheResolver {
    private final String resourceRoot;

    public ClasspathResolver() {
        this.resourceRoot = null;
    }

    public ClasspathResolver(String resourceRoot) {
        this.resourceRoot = resourceRoot;
    }

    @Override
    public Reader getReader(String resourceName) {
        String fullResourceName;
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        InputStream is = ccl.getResourceAsStream(fullResourceName = this.concatResourceRootAndResourceName(resourceName));
        if (is == null) {
            ClassLoader classLoader = ClasspathResolver.class.getClassLoader();
            is = classLoader.getResourceAsStream(fullResourceName);
        }
        if (is != null) {
            return new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        }
        return null;
    }

    private String concatResourceRootAndResourceName(String resourceName) {
        if (this.resourceRoot == null || resourceName == null) {
            return resourceName;
        }
        if (resourceName.startsWith("/") && this.resourceRoot.endsWith("/")) {
            return this.resourceRoot.substring(0, this.resourceRoot.length() - 1) + resourceName;
        }
        if (resourceName.startsWith("/") && !this.resourceRoot.endsWith("/") || !resourceName.startsWith("/") && this.resourceRoot.endsWith("/")) {
            return this.resourceRoot + resourceName;
        }
        return this.resourceRoot + "/" + resourceName;
    }
}

