/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.http.client.protocol;

import conductor.org.apache.http.HttpEntity;
import conductor.org.apache.http.HttpEntityEnclosingRequest;
import conductor.org.apache.http.HttpException;
import conductor.org.apache.http.HttpRequest;
import conductor.org.apache.http.HttpRequestInterceptor;
import conductor.org.apache.http.HttpVersion;
import conductor.org.apache.http.ProtocolVersion;
import conductor.org.apache.http.annotation.Immutable;
import conductor.org.apache.http.client.config.RequestConfig;
import conductor.org.apache.http.client.protocol.HttpClientContext;
import conductor.org.apache.http.protocol.HttpContext;
import conductor.org.apache.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

