/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.analysis.el;

import conductor.org.apache.lucene.analysis.Analyzer;
import conductor.org.apache.lucene.analysis.CharArraySet;
import conductor.org.apache.lucene.analysis.StopFilter;
import conductor.org.apache.lucene.analysis.StopwordAnalyzerBase;
import conductor.org.apache.lucene.analysis.TokenFilter;
import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.analysis.el.GreekLowerCaseFilter;
import conductor.org.apache.lucene.analysis.el.GreekStemFilter;
import conductor.org.apache.lucene.analysis.standard.StandardTokenizer;
import java.io.IOException;

public final class GreekAnalyzer
extends StopwordAnalyzerBase {
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";

    public static final CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_SET;
    }

    public GreekAnalyzer() {
        this(DefaultSetHolder.DEFAULT_SET);
    }

    public GreekAnalyzer(CharArraySet stopwords) {
        super(stopwords);
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result = new GreekLowerCaseFilter(source);
        result = new StopFilter(result, this.stopwords);
        result = new GreekStemFilter(result);
        return new Analyzer.TokenStreamComponents(source, result);
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new GreekLowerCaseFilter(in);
    }

    private static class DefaultSetHolder {
        private static final CharArraySet DEFAULT_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_SET = GreekAnalyzer.loadStopwordSet(false, GreekAnalyzer.class, GreekAnalyzer.DEFAULT_STOPWORD_FILE, "#");
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

