/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.analysis.miscellaneous;

import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import conductor.org.apache.lucene.analysis.util.AbstractAnalysisFactory;
import conductor.org.apache.lucene.analysis.util.MultiTermAwareComponent;
import conductor.org.apache.lucene.analysis.util.TokenFilterFactory;
import java.util.HashMap;
import java.util.Map;

public class ASCIIFoldingFilterFactory
extends TokenFilterFactory
implements MultiTermAwareComponent {
    private static final String PRESERVE_ORIGINAL = "preserveOriginal";
    private final boolean preserveOriginal;

    public ASCIIFoldingFilterFactory(Map<String, String> args) {
        super(args);
        this.preserveOriginal = this.getBoolean(args, PRESERVE_ORIGINAL, false);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public ASCIIFoldingFilter create(TokenStream input) {
        return new ASCIIFoldingFilter(input, this.preserveOriginal);
    }

    @Override
    public AbstractAnalysisFactory getMultiTermComponent() {
        if (this.preserveOriginal) {
            HashMap<String, String> args = new HashMap<String, String>(this.getOriginalArgs());
            args.remove(PRESERVE_ORIGINAL);
            return new ASCIIFoldingFilterFactory(args);
        }
        return this;
    }
}

