/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.analysis.miscellaneous;

import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import conductor.org.apache.lucene.util.Attribute;
import conductor.org.apache.lucene.util.AttributeSource;
import conductor.org.apache.lucene.util.IOUtils;
import java.io.IOException;
import java.util.Iterator;

public final class ConcatenatingTokenStream
extends TokenStream {
    private final TokenStream[] sources;
    private final OffsetAttribute[] sourceOffsets;
    private final OffsetAttribute offsetAtt;
    private int currentSource;
    private int offsetIncrement;

    public ConcatenatingTokenStream(TokenStream ... sources) {
        super(ConcatenatingTokenStream.combineSources(sources));
        this.sources = sources;
        this.offsetAtt = this.addAttribute(OffsetAttribute.class);
        this.sourceOffsets = new OffsetAttribute[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            this.sourceOffsets[i] = sources[i].addAttribute(OffsetAttribute.class);
        }
    }

    private static AttributeSource combineSources(TokenStream ... sources) {
        AttributeSource base = sources[0].cloneAttributes();
        try {
            for (int i = 1; i < sources.length; ++i) {
                Iterator<Class<? extends Attribute>> it = sources[i].getAttributeClassesIterator();
                while (it.hasNext()) {
                    base.addAttribute(it.next());
                }
                sources[i].copyTo(base);
            }
            return base;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Attempted to concatenate TokenStreams with different attribute types", e);
        }
    }

    @Override
    public boolean incrementToken() throws IOException {
        while (!this.sources[this.currentSource].incrementToken()) {
            if (this.currentSource >= this.sources.length - 1) {
                return false;
            }
            this.sources[this.currentSource].end();
            OffsetAttribute att = this.sourceOffsets[this.currentSource];
            if (att != null) {
                this.offsetIncrement += att.endOffset();
            }
            ++this.currentSource;
        }
        this.clearAttributes();
        this.sources[this.currentSource].copyTo(this);
        this.offsetAtt.setOffset(this.offsetAtt.startOffset() + this.offsetIncrement, this.offsetAtt.endOffset() + this.offsetIncrement);
        return true;
    }

    @Override
    public void end() throws IOException {
        this.sources[this.currentSource].end();
        super.end();
    }

    @Override
    public void reset() throws IOException {
        for (TokenStream source : this.sources) {
            source.reset();
        }
        super.reset();
    }

    @Override
    public void close() throws IOException {
        try {
            IOUtils.close(this.sources);
        }
        finally {
            super.close();
        }
    }
}

