/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.analysis.util;

import conductor.org.apache.lucene.analysis.CharArraySet;
import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.analysis.fr.FrenchAnalyzer;
import conductor.org.apache.lucene.analysis.util.AbstractAnalysisFactory;
import conductor.org.apache.lucene.analysis.util.ElisionFilter;
import conductor.org.apache.lucene.analysis.util.MultiTermAwareComponent;
import conductor.org.apache.lucene.analysis.util.ResourceLoader;
import conductor.org.apache.lucene.analysis.util.ResourceLoaderAware;
import conductor.org.apache.lucene.analysis.util.TokenFilterFactory;
import java.io.IOException;
import java.util.Map;

public class ElisionFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware,
MultiTermAwareComponent {
    private final String articlesFile;
    private final boolean ignoreCase;
    private CharArraySet articles;

    public ElisionFilterFactory(Map<String, String> args) {
        super(args);
        this.articlesFile = this.get(args, "articles");
        this.ignoreCase = this.getBoolean(args, "ignoreCase", false);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        this.articles = this.articlesFile == null ? FrenchAnalyzer.DEFAULT_ARTICLES : this.getWordSet(loader, this.articlesFile, this.ignoreCase);
    }

    @Override
    public ElisionFilter create(TokenStream input) {
        return new ElisionFilter(input, this.articles);
    }

    @Override
    public AbstractAnalysisFactory getMultiTermComponent() {
        return this;
    }
}

