/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.document;

import conductor.org.apache.lucene.document.LatLonShape;
import conductor.org.apache.lucene.index.FieldInfo;
import conductor.org.apache.lucene.index.LeafReader;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.PointValues;
import conductor.org.apache.lucene.search.ConstantScoreScorer;
import conductor.org.apache.lucene.search.ConstantScoreWeight;
import conductor.org.apache.lucene.search.DocIdSetIterator;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.Scorer;
import conductor.org.apache.lucene.search.ScorerSupplier;
import conductor.org.apache.lucene.search.Weight;
import conductor.org.apache.lucene.util.BitSetIterator;
import conductor.org.apache.lucene.util.DocIdSetBuilder;
import conductor.org.apache.lucene.util.FixedBitSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

abstract class LatLonShapeQuery
extends Query {
    final String field;
    final LatLonShape.QueryRelation queryRelation;

    protected LatLonShapeQuery(String field, LatLonShape.QueryRelation queryType) {
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        this.field = field;
        this.queryRelation = queryType;
    }

    protected abstract PointValues.Relation relateRangeBBoxToQuery(int var1, int var2, byte[] var3, int var4, int var5, byte[] var6);

    protected abstract boolean queryMatches(byte[] var1);

    protected PointValues.Relation relateRangeToQuery(byte[] minTriangle, byte[] maxTriangle) {
        int minXOfs = 0;
        int minYOfs = 0;
        int maxXOfs = 0;
        int maxYOfs = 0;
        for (int d = 1; d < 3; ++d) {
            int bOfs = d * 2 * 4 + 4;
            int aOfs = minXOfs * 2 * 4 + 4;
            if (Arrays.compareUnsigned(minTriangle, bOfs, bOfs + 4, minTriangle, aOfs, aOfs + 4) < 0) {
                minXOfs = d;
            }
            if (Arrays.compareUnsigned(maxTriangle, bOfs, bOfs + 4, maxTriangle, aOfs = maxXOfs * 2 * 4 + 4, aOfs + 4) > 0) {
                maxXOfs = d;
            }
            if (Arrays.compareUnsigned(minTriangle, bOfs = d * 2 * 4, bOfs + 4, minTriangle, aOfs = minYOfs * 2 * 4, aOfs + 4) < 0) {
                minYOfs = d;
            }
            if (Arrays.compareUnsigned(maxTriangle, bOfs, bOfs + 4, maxTriangle, aOfs = maxYOfs * 2 * 4, aOfs + 4) <= 0) continue;
            maxYOfs = d;
        }
        minXOfs = minXOfs * 2 * 4 + 4;
        maxXOfs = maxXOfs * 2 * 4 + 4;
        PointValues.Relation r = this.relateRangeBBoxToQuery(minXOfs, minYOfs *= 8, minTriangle, maxXOfs, maxYOfs *= 8, maxTriangle);
        if (this.queryRelation == LatLonShape.QueryRelation.DISJOINT) {
            return LatLonShapeQuery.transposeRelation(r);
        }
        return r;
    }

    @Override
    public final Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            protected PointValues.IntersectVisitor getSparseIntersectVisitor(final DocIdSetBuilder result) {
                return new PointValues.IntersectVisitor(){
                    DocIdSetBuilder.BulkAdder adder;

                    @Override
                    public void grow(int count) {
                        this.adder = result.grow(count);
                    }

                    @Override
                    public void visit(int docID) throws IOException {
                        this.adder.add(docID);
                    }

                    @Override
                    public void visit(int docID, byte[] t) throws IOException {
                        if (LatLonShapeQuery.this.queryMatches(t)) {
                            this.adder.add(docID);
                        }
                    }

                    @Override
                    public PointValues.Relation compare(byte[] minTriangle, byte[] maxTriangle) {
                        return LatLonShapeQuery.this.relateRangeToQuery(minTriangle, maxTriangle);
                    }
                };
            }

            protected PointValues.IntersectVisitor getDenseIntersectVisitor(final FixedBitSet intersect, final FixedBitSet disjoint) {
                return new PointValues.IntersectVisitor(){

                    @Override
                    public void visit(int docID) throws IOException {
                        if (LatLonShapeQuery.this.queryRelation == LatLonShape.QueryRelation.DISJOINT) {
                            disjoint.set(docID);
                        } else {
                            intersect.set(docID);
                        }
                    }

                    @Override
                    public void visit(int docID, byte[] t) throws IOException {
                        if (LatLonShapeQuery.this.queryMatches(t)) {
                            intersect.set(docID);
                        } else {
                            disjoint.set(docID);
                        }
                    }

                    @Override
                    public PointValues.Relation compare(byte[] minTriangle, byte[] maxTriangle) {
                        return LatLonShapeQuery.this.relateRangeToQuery(minTriangle, maxTriangle);
                    }
                };
            }

            protected ScorerSupplier getIntersectScorerSupplier(final LeafReader reader, PointValues values, final Weight weight) throws IOException {
                final DocIdSetBuilder result = new DocIdSetBuilder(reader.maxDoc(), values, LatLonShapeQuery.this.field);
                PointValues.IntersectVisitor visitor = this.getSparseIntersectVisitor(result);
                return new RelationScorerSupplier(values, visitor){

                    @Override
                    public Scorer get(long leadCost) throws IOException {
                        return this.getIntersectsScorer(LatLonShapeQuery.this, reader, weight, result, this.score());
                    }
                };
            }

            protected ScorerSupplier getScorerSupplier(LeafReader reader, PointValues values, final Weight weight) throws IOException {
                if (LatLonShapeQuery.this.queryRelation == LatLonShape.QueryRelation.INTERSECTS) {
                    return this.getIntersectScorerSupplier(reader, values, weight);
                }
                final FixedBitSet intersect = new FixedBitSet(reader.maxDoc());
                final FixedBitSet disjoint = new FixedBitSet(reader.maxDoc());
                PointValues.IntersectVisitor visitor = this.getDenseIntersectVisitor(intersect, disjoint);
                return new RelationScorerSupplier(values, visitor){

                    @Override
                    public Scorer get(long leadCost) throws IOException {
                        return this.getScorer(LatLonShapeQuery.this, weight, intersect, disjoint, this.score());
                    }
                };
            }

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final LeafReader reader = context.reader();
                PointValues values = reader.getPointValues(LatLonShapeQuery.this.field);
                if (values == null) {
                    return null;
                }
                FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(LatLonShapeQuery.this.field);
                if (fieldInfo == null) {
                    return null;
                }
                boolean allDocsMatch = true;
                if (values.getDocCount() != reader.maxDoc() || LatLonShapeQuery.this.relateRangeToQuery(values.getMinPackedValue(), values.getMaxPackedValue()) != PointValues.Relation.CELL_INSIDE_QUERY) {
                    allDocsMatch = false;
                }
                final 1 weight = this;
                if (allDocsMatch) {
                    return new ScorerSupplier(){

                        @Override
                        public Scorer get(long leadCost) throws IOException {
                            return new ConstantScoreScorer(weight, this.score(), DocIdSetIterator.all(reader.maxDoc()));
                        }

                        @Override
                        public long cost() {
                            return reader.maxDoc();
                        }
                    };
                }
                return this.getScorerSupplier(reader, values, weight);
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                if (scorerSupplier == null) {
                    return null;
                }
                return scorerSupplier.get(Long.MAX_VALUE);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    public String getField() {
        return this.field;
    }

    public LatLonShape.QueryRelation getQueryRelation() {
        return this.queryRelation;
    }

    @Override
    public int hashCode() {
        int hash = this.classHash();
        hash = 31 * hash + this.field.hashCode();
        hash = 31 * hash + this.queryRelation.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo(o);
    }

    protected boolean equalsTo(Object o) {
        return Objects.equals(this.field, ((LatLonShapeQuery)o).field) && this.queryRelation == ((LatLonShapeQuery)o).queryRelation;
    }

    private static PointValues.Relation transposeRelation(PointValues.Relation r) {
        if (r == PointValues.Relation.CELL_INSIDE_QUERY) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (r == PointValues.Relation.CELL_OUTSIDE_QUERY) {
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
        return PointValues.Relation.CELL_CROSSES_QUERY;
    }

    static /* synthetic */ PointValues.Relation access$300(PointValues.Relation x0) {
        return LatLonShapeQuery.transposeRelation(x0);
    }

    protected static abstract class RelationScorerSupplier
    extends ScorerSupplier {
        PointValues values;
        PointValues.IntersectVisitor visitor;
        long cost = -1L;

        RelationScorerSupplier(PointValues values, PointValues.IntersectVisitor visitor) {
            this.values = values;
            this.visitor = visitor;
        }

        private PointValues.IntersectVisitor getInverseIntersectVisitor(final LatLonShapeQuery query, final FixedBitSet result, final int[] cost) {
            return new PointValues.IntersectVisitor(){

                @Override
                public void visit(int docID) {
                    result.clear(docID);
                    cost[0] = cost[0] - 1;
                }

                @Override
                public void visit(int docID, byte[] packedTriangle) {
                    if (!query.queryMatches(packedTriangle)) {
                        result.clear(docID);
                        cost[0] = cost[0] - 1;
                    }
                }

                @Override
                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                    return LatLonShapeQuery.transposeRelation(query.relateRangeToQuery(minPackedValue, maxPackedValue));
                }
            };
        }

        protected Scorer getIntersectsScorer(LatLonShapeQuery query, LeafReader reader, Weight weight, DocIdSetBuilder docIdSetBuilder, float boost) throws IOException {
            if (this.values.getDocCount() == reader.maxDoc() && (long)this.values.getDocCount() == this.values.size() && this.cost() > (long)(reader.maxDoc() / 2)) {
                FixedBitSet result = new FixedBitSet(reader.maxDoc());
                result.set(0, reader.maxDoc());
                int[] cost = new int[]{reader.maxDoc()};
                this.values.intersect(this.getInverseIntersectVisitor(query, result, cost));
                BitSetIterator iterator = new BitSetIterator(result, cost[0]);
                return new ConstantScoreScorer(weight, boost, iterator);
            }
            this.values.intersect(this.visitor);
            DocIdSetIterator iterator = docIdSetBuilder.build().iterator();
            return new ConstantScoreScorer(weight, boost, iterator);
        }

        protected Scorer getScorer(LatLonShapeQuery query, Weight weight, FixedBitSet intersect, FixedBitSet disjoint, float boost) throws IOException {
            BitSetIterator iterator;
            this.values.intersect(this.visitor);
            if (query.queryRelation == LatLonShape.QueryRelation.DISJOINT) {
                disjoint.andNot(intersect);
                iterator = new BitSetIterator(disjoint, this.cost());
            } else if (query.queryRelation == LatLonShape.QueryRelation.WITHIN) {
                intersect.andNot(disjoint);
                iterator = new BitSetIterator(intersect, this.cost());
            } else {
                iterator = new BitSetIterator(intersect, this.cost());
            }
            return new ConstantScoreScorer(weight, boost, iterator);
        }

        @Override
        public long cost() {
            if (this.cost == -1L) {
                this.cost = this.values.estimatePointCount(this.visitor);
                assert (this.cost >= 0L);
            }
            return this.cost;
        }
    }
}

