/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.geo;

import conductor.org.apache.lucene.geo.GeoUtils;
import conductor.org.apache.lucene.geo.Polygon;
import java.util.Arrays;

public class Line {
    private final double[] lats;
    private final double[] lons;
    public final double minLat;
    public final double maxLat;
    public final double minLon;
    public final double maxLon;

    public Line(double[] lats, double[] lons) {
        if (lats == null) {
            throw new IllegalArgumentException("lats must not be null");
        }
        if (lons == null) {
            throw new IllegalArgumentException("lons must not be null");
        }
        if (lats.length != lons.length) {
            throw new IllegalArgumentException("lats and lons must be equal length");
        }
        if (lats.length < 2) {
            throw new IllegalArgumentException("at least 2 line points required");
        }
        double minLat = lats[0];
        double minLon = lons[0];
        double maxLat = lats[0];
        double maxLon = lons[0];
        for (int i = 0; i < lats.length; ++i) {
            GeoUtils.checkLatitude(lats[i]);
            GeoUtils.checkLongitude(lons[i]);
            minLat = Math.min(lats[i], minLat);
            minLon = Math.min(lons[i], minLon);
            maxLat = Math.max(lats[i], maxLat);
            maxLon = Math.max(lons[i], maxLon);
        }
        this.lats = (double[])lats.clone();
        this.lons = (double[])lons.clone();
        this.minLat = minLat;
        this.maxLat = maxLat;
        this.minLon = minLon;
        this.maxLon = maxLon;
    }

    public int numPoints() {
        return this.lats.length;
    }

    public double getLat(int vertex) {
        return this.lats[vertex];
    }

    public double getLon(int vertex) {
        return this.lons[vertex];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Line)) {
            return false;
        }
        Line line = (Line)o;
        return Arrays.equals(this.lats, line.lats) && Arrays.equals(this.lons, line.lons);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.lats);
        result = 31 * result + Arrays.hashCode(this.lons);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LINE(");
        for (int i = 0; i < this.lats.length; ++i) {
            sb.append("[").append(this.lats[i]).append(", ").append(this.lons[i]).append("]");
        }
        sb.append(')');
        return sb.toString();
    }

    public String toGeoJSON() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(Polygon.verticesToGeoJSON(this.lats, this.lons));
        sb.append("]");
        return sb.toString();
    }
}

