/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.index;

import conductor.org.apache.lucene.codecs.Codec;
import conductor.org.apache.lucene.index.IndexFileNames;
import conductor.org.apache.lucene.search.Sort;
import conductor.org.apache.lucene.store.Directory;
import conductor.org.apache.lucene.store.TrackingDirectoryWrapper;
import conductor.org.apache.lucene.util.Version;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;

public final class SegmentInfo {
    public static final int NO = -1;
    public static final int YES = 1;
    public final String name;
    private int maxDoc;
    public final Directory dir;
    private boolean isCompoundFile;
    private final byte[] id;
    private Codec codec;
    private Map<String, String> diagnostics;
    private final Map<String, String> attributes;
    private final Sort indexSort;
    private final Version version;
    Version minVersion;
    private Set<String> setFiles;

    void setDiagnostics(Map<String, String> diagnostics) {
        this.diagnostics = Objects.requireNonNull(diagnostics);
    }

    public Map<String, String> getDiagnostics() {
        return this.diagnostics;
    }

    public SegmentInfo(Directory dir, Version version, Version minVersion, String name, int maxDoc, boolean isCompoundFile, Codec codec, Map<String, String> diagnostics, byte[] id, Map<String, String> attributes, Sort indexSort) {
        assert (!(dir instanceof TrackingDirectoryWrapper));
        this.dir = Objects.requireNonNull(dir);
        this.version = Objects.requireNonNull(version);
        this.minVersion = minVersion;
        this.name = Objects.requireNonNull(name);
        this.maxDoc = maxDoc;
        this.isCompoundFile = isCompoundFile;
        this.codec = codec;
        this.diagnostics = Objects.requireNonNull(diagnostics);
        this.id = id;
        if (id.length != 16) {
            throw new IllegalArgumentException("invalid id: " + Arrays.toString(id));
        }
        this.attributes = Objects.requireNonNull(attributes);
        this.indexSort = indexSort;
    }

    void setUseCompoundFile(boolean isCompoundFile) {
        this.isCompoundFile = isCompoundFile;
    }

    public boolean getUseCompoundFile() {
        return this.isCompoundFile;
    }

    public void setCodec(Codec codec) {
        assert (this.codec == null);
        if (codec == null) {
            throw new IllegalArgumentException("codec must be non-null");
        }
        this.codec = codec;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public int maxDoc() {
        if (this.maxDoc == -1) {
            throw new IllegalStateException("maxDoc isn't set yet");
        }
        return this.maxDoc;
    }

    void setMaxDoc(int maxDoc) {
        if (this.maxDoc != -1) {
            throw new IllegalStateException("maxDoc was already set: this.maxDoc=" + this.maxDoc + " vs maxDoc=" + maxDoc);
        }
        this.maxDoc = maxDoc;
    }

    public Set<String> files() {
        if (this.setFiles == null) {
            throw new IllegalStateException("files were not computed yet; segment=" + this.name + " maxDoc=" + this.maxDoc);
        }
        return Collections.unmodifiableSet(this.setFiles);
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int delCount) {
        StringBuilder s = new StringBuilder();
        s.append(this.name).append('(').append(this.version == null ? "?" : this.version).append(')').append(':');
        char cfs = this.getUseCompoundFile() ? (char)'c' : 'C';
        s.append(cfs);
        s.append(this.maxDoc);
        if (delCount != 0) {
            s.append('/').append(delCount);
        }
        if (this.indexSort != null) {
            s.append(":[indexSort=");
            s.append(this.indexSort);
            s.append(']');
        }
        return s.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SegmentInfo) {
            SegmentInfo other = (SegmentInfo)obj;
            return other.dir == this.dir && other.name.equals(this.name);
        }
        return false;
    }

    public int hashCode() {
        return this.dir.hashCode() + this.name.hashCode();
    }

    public Version getVersion() {
        return this.version;
    }

    public Version getMinVersion() {
        return this.minVersion;
    }

    public byte[] getId() {
        return (byte[])this.id.clone();
    }

    public void setFiles(Collection<String> files) {
        this.setFiles = new HashSet<String>();
        this.addFiles(files);
    }

    public void addFiles(Collection<String> files) {
        this.checkFileNames(files);
        for (String f : files) {
            this.setFiles.add(this.namedForThisSegment(f));
        }
    }

    public void addFile(String file) {
        this.checkFileNames(Collections.singleton(file));
        this.setFiles.add(this.namedForThisSegment(file));
    }

    private void checkFileNames(Collection<String> files) {
        Matcher m = IndexFileNames.CODEC_FILE_PATTERN.matcher("");
        for (String file : files) {
            m.reset(file);
            if (!m.matches()) {
                throw new IllegalArgumentException("invalid codec filename '" + file + "', must match: " + IndexFileNames.CODEC_FILE_PATTERN.pattern());
            }
            if (!file.toLowerCase(Locale.ROOT).endsWith(".tmp")) continue;
            throw new IllegalArgumentException("invalid codec filename '" + file + "', cannot end with .tmp extension");
        }
    }

    String namedForThisSegment(String file) {
        return this.name + IndexFileNames.stripSegmentName(file);
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public String putAttribute(String key, String value) {
        return this.attributes.put(key, value);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Sort getIndexSort() {
        return this.indexSort;
    }
}

