/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.queries.function.valuesource;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.queries.function.FunctionValues;
import conductor.org.apache.lucene.queries.function.valuesource.ConstDoubleDocValues;
import conductor.org.apache.lucene.queries.function.valuesource.DocFreqValueSource;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.apache.lucene.search.similarities.PerFieldSimilarityWrapper;
import conductor.org.apache.lucene.search.similarities.Similarity;
import conductor.org.apache.lucene.search.similarities.TFIDFSimilarity;
import conductor.org.apache.lucene.util.BytesRef;
import java.io.IOException;
import java.util.Map;

public class IDFValueSource
extends DocFreqValueSource {
    public IDFValueSource(String field, String val, String indexedField, BytesRef indexedBytes) {
        super(field, val, indexedField, indexedBytes);
    }

    @Override
    public String name() {
        return "idf";
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        IndexSearcher searcher = (IndexSearcher)context.get("searcher");
        TFIDFSimilarity sim = IDFValueSource.asTFIDF(searcher.getSimilarity(true), this.field);
        if (sim == null) {
            throw new UnsupportedOperationException("requires a TFIDFSimilarity (such as ClassicSimilarity)");
        }
        int docfreq = searcher.getIndexReader().docFreq(new Term(this.indexedField, this.indexedBytes));
        float idf = sim.idf(docfreq, searcher.getIndexReader().maxDoc());
        return new ConstDoubleDocValues(idf, this);
    }

    static TFIDFSimilarity asTFIDF(Similarity sim, String field) {
        while (sim instanceof PerFieldSimilarityWrapper) {
            sim = ((PerFieldSimilarityWrapper)sim).get(field);
        }
        if (sim instanceof TFIDFSimilarity) {
            return (TFIDFSimilarity)sim;
        }
        return null;
    }
}

