/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.queryparser.flexible.standard.builders;

import conductor.org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import conductor.org.apache.lucene.queryparser.flexible.core.builders.QueryTreeBuilder;
import conductor.org.apache.lucene.queryparser.flexible.core.messages.QueryParserMessages;
import conductor.org.apache.lucene.queryparser.flexible.core.nodes.BooleanQueryNode;
import conductor.org.apache.lucene.queryparser.flexible.core.nodes.ModifierQueryNode;
import conductor.org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import conductor.org.apache.lucene.queryparser.flexible.messages.MessageImpl;
import conductor.org.apache.lucene.queryparser.flexible.standard.builders.StandardQueryBuilder;
import conductor.org.apache.lucene.queryparser.flexible.standard.parser.EscapeQuerySyntaxImpl;
import conductor.org.apache.lucene.search.BooleanClause;
import conductor.org.apache.lucene.search.BooleanQuery;
import conductor.org.apache.lucene.search.Query;
import java.util.List;

public class BooleanQueryNodeBuilder
implements StandardQueryBuilder {
    @Override
    public BooleanQuery build(QueryNode queryNode) throws QueryNodeException {
        BooleanQueryNode booleanNode = (BooleanQueryNode)queryNode;
        BooleanQuery.Builder bQuery = new BooleanQuery.Builder();
        List<QueryNode> children = booleanNode.getChildren();
        if (children != null) {
            for (QueryNode child : children) {
                Object obj = child.getTag(QueryTreeBuilder.QUERY_TREE_BUILDER_TAGID);
                if (obj == null) continue;
                Query query = (Query)obj;
                try {
                    bQuery.add(query, BooleanQueryNodeBuilder.getModifierValue(child));
                }
                catch (BooleanQuery.TooManyClauses ex) {
                    throw new QueryNodeException(new MessageImpl(QueryParserMessages.TOO_MANY_BOOLEAN_CLAUSES, BooleanQuery.getMaxClauseCount(), queryNode.toQueryString(new EscapeQuerySyntaxImpl())), (Throwable)ex);
                }
            }
        }
        return bQuery.build();
    }

    private static BooleanClause.Occur getModifierValue(QueryNode node) {
        if (node instanceof ModifierQueryNode) {
            ModifierQueryNode mNode = (ModifierQueryNode)node;
            switch (mNode.getModifier()) {
                case MOD_REQ: {
                    return BooleanClause.Occur.MUST;
                }
                case MOD_NOT: {
                    return BooleanClause.Occur.MUST_NOT;
                }
                case MOD_NONE: {
                    return BooleanClause.Occur.SHOULD;
                }
            }
        }
        return BooleanClause.Occur.SHOULD;
    }
}

