/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search;

import conductor.org.apache.lucene.geo.GeoUtils;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.PointValues;
import conductor.org.apache.lucene.search.FieldDoc;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.apache.lucene.search.NearestNeighbor;
import conductor.org.apache.lucene.search.ScoreDoc;
import conductor.org.apache.lucene.search.TopFieldDocs;
import conductor.org.apache.lucene.util.Bits;
import conductor.org.apache.lucene.util.bkd.BKDReader;
import java.io.IOException;
import java.util.ArrayList;

public class LatLonPointPrototypeQueries {
    private LatLonPointPrototypeQueries() {
    }

    public static TopFieldDocs nearest(IndexSearcher searcher, String field, double latitude, double longitude, int n) throws IOException {
        GeoUtils.checkLatitude(latitude);
        GeoUtils.checkLongitude(longitude);
        if (n < 1) {
            throw new IllegalArgumentException("n must be at least 1; got " + n);
        }
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (searcher == null) {
            throw new IllegalArgumentException("searcher must not be null");
        }
        ArrayList<BKDReader> readers = new ArrayList<BKDReader>();
        ArrayList<Integer> docBases = new ArrayList<Integer>();
        ArrayList<Bits> liveDocs = new ArrayList<Bits>();
        int totalHits = 0;
        for (LeafReaderContext leaf : searcher.getIndexReader().leaves()) {
            PointValues points = leaf.reader().getPointValues(field);
            if (points == null) continue;
            if (!(points instanceof BKDReader)) {
                throw new IllegalArgumentException("can only run on Lucene60PointsReader points implementation, but got " + points);
            }
            totalHits += points.getDocCount();
            BKDReader reader = (BKDReader)points;
            if (reader == null) continue;
            readers.add(reader);
            docBases.add(leaf.docBase);
            liveDocs.add(leaf.reader().getLiveDocs());
        }
        NearestNeighbor.NearestHit[] hits = NearestNeighbor.nearest(latitude, longitude, readers, liveDocs, docBases, n);
        ScoreDoc[] scoreDocs = new ScoreDoc[hits.length];
        for (int i = 0; i < hits.length; ++i) {
            NearestNeighbor.NearestHit hit = hits[i];
            scoreDocs[i] = new FieldDoc(hit.docID, 0.0f, new Object[]{hit.distanceMeters});
        }
        return new TopFieldDocs(totalHits, scoreDocs, null, 0.0f);
    }
}

